/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jtester.json.decoder.JSONDecoder;
import org.jtester.json.encoder.JSONEncoder;
import org.jtester.json.helper.JSONArray;
import org.jtester.json.helper.JSONFeature;
import org.jtester.json.helper.JSONMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONScanner;
import org.jtester.json.helper.JSONSingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSON {
    public static final <T> T toObject(String json) {
        if (json == null) {
            return null;
        }
        JSONObject jsonObject = JSONScanner.scnJSON(json);
        T o = JSON.toObject(jsonObject, new HashMap<String, Object>());
        return o;
    }

    public static final <T> T toObject(String json, Class clazz) {
        if (json == null) {
            return null;
        }
        JSONObject jsonObject = JSONScanner.scnJSON(json);
        T o = JSON.toObject(jsonObject, clazz, new HashMap<String, Object>());
        return o;
    }

    public static final <T> T toObject(JSONObject json, Map<String, Object> references) {
        if (json instanceof JSONArray) {
            T o = JSON.toObject(json, Object[].class, references);
            return o;
        }
        if (json instanceof JSONMap) {
            Class clazz = ((JSONMap)json).getClazzFromJSONFProp(HashMap.class);
            T o = JSON.toObject(json, clazz, references);
            return o;
        }
        String value = ((JSONSingle)json).toStringValue();
        return (T)value;
    }

    public static final <T> T toObject(JSONObject json, Class clazz, Map<String, Object> references) {
        if (clazz == null) {
            throw new RuntimeException("the decode class can't be null.");
        }
        JSONDecoder decoder = JSONDecoder.get(clazz);
        Object obj = decoder.decode(json, references);
        return obj;
    }

    public static final String toJSON(Object object, JSONFeature ... features) {
        if (object == null) {
            return "null";
        }
        int value = JSONFeature.getFeaturesMask(features);
        String json = JSON.toJSON(object, value);
        return json;
    }

    public static final String toJSON(Object object, int features) {
        if (object == null) {
            return "null";
        }
        StringWriter writer = new StringWriter();
        JSONEncoder encoder = JSONEncoder.get(object.getClass());
        encoder.setFeatures(features);
        ArrayList<String> references = new ArrayList<String>();
        encoder.encode(object, writer, references);
        String json = writer.toString();
        return json;
    }
}

