/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder;

import java.util.Collection;
import java.util.Map;
import org.jtester.json.decoder.ArrayDecoder;
import org.jtester.json.decoder.array.CollectionDecoder;
import org.jtester.json.decoder.object.MapDecoder;
import org.jtester.json.decoder.object.PoJoDecoder;
import org.jtester.json.decoder.single.FixedTypeDecoder;
import org.jtester.json.decoder.single.SpecTypeDecoder;
import org.jtester.json.helper.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONDecoder<T> {
    protected final Class clazz;
    protected Class realTargetType;

    protected JSONDecoder(Class clazz) {
        this.clazz = clazz;
        this.realTargetType = clazz;
    }

    public abstract T decode(JSONObject var1, Map<String, Object> var2);

    public static JSONDecoder get(Class clazz) {
        FixedTypeDecoder decoder = FixedTypeDecoder.isFinalDecoder(clazz);
        if (decoder != null) {
            return decoder;
        }
        SpecTypeDecoder specTypeDecoder = SpecTypeDecoder.isSpecTypeDecoder(clazz);
        if (specTypeDecoder != null) {
            return specTypeDecoder;
        }
        if (clazz.isArray()) {
            return ArrayDecoder.getObjectArrayDecoder(clazz.getComponentType());
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionDecoder(clazz);
        }
        if (Map.class.isAssignableFrom(clazz) || clazz == Object.class) {
            return new MapDecoder(clazz);
        }
        return new PoJoDecoder(clazz);
    }
}

