/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder;

import java.util.HashMap;
import java.util.Map;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JSONException;
import org.jtester.json.decoder.JSONDecoder;
import org.jtester.json.helper.JSONMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONSingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectDecoder<T>
extends JSONDecoder<T> {
    protected ObjectDecoder(Class clazz) {
        super(clazz);
    }

    @Override
    public final T decode(JSONObject json, Map<String, Object> references) {
        if (json == null) {
            return null;
        }
        if (json instanceof JSONSingle) {
            String value = ((JSONSingle)json).toStringValue();
            return (T)value;
        }
        if (!(json instanceof JSONMap)) {
            throw new JSONException("illegal type for JavaBeanDecoder. the json[" + json.toString() + "] isn't a JSONMap");
        }
        JSONMap map = (JSONMap)json;
        String referenceID = map.getReferFromJSONProp();
        if (referenceID != null) {
            Object o = references.get(referenceID);
            return (T)o;
        }
        T target = this.newInstance(map, references);
        this.parseFromJSONMap(target, map, references);
        return target;
    }

    private T newInstance(JSONMap map, Map<String, Object> references) {
        this.realTargetType = map.getClazzFromJSONFProp(this.clazz);
        if (ClazzHelper.isInterfaceOrAbstract(this.realTargetType)) {
            throw new JSONException("the type[" + this.realTargetType.getName() + "] is an interface or abstract class,that can't be instnaced.");
        }
        if (this.clazz == Object.class) {
            HashMap target = new HashMap();
            return (T)target;
        }
        Object target = ClazzHelper.newInstance(this.realTargetType);
        String referenceID = map.getReferenceID();
        if (referenceID != null) {
            references.put(referenceID, target);
        }
        return target;
    }

    protected abstract void parseFromJSONMap(T var1, JSONMap var2, Map<String, Object> var3);
}

