/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder.single;

import java.util.Map;
import org.jtester.json.decoder.SingleDecoder;
import org.jtester.json.helper.JSONMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONSingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FixedTypeDecoder<T>
extends SingleDecoder<T> {
    protected FixedTypeDecoder(Class clazz) {
        super(clazz);
    }

    @Override
    public T decode(JSONObject json, Map<String, Object> references) {
        if (json == null) {
            return null;
        }
        if (json instanceof JSONMap) {
            return this.decodeFromJSONMap((JSONMap)json);
        }
        if (json instanceof JSONSingle) {
            T value = this.decodeFromJSONSingle((JSONSingle)json);
            return value;
        }
        throw new RuntimeException("syntax error, JSONObject of Single Type can't be JSONArray.");
    }

    protected final T decodeFromJSONSingle(JSONSingle single) {
        String value = single.toStringValue();
        if (value == null || value.length() == 0) {
            return null;
        }
        T object = this.decodeFromString(value);
        return object;
    }

    protected T decodeFromJSONMap(JSONMap map) {
        JSONObject jsonObject = map.getValueFromJSONProp();
        if (jsonObject instanceof JSONSingle) {
            T o = this.decodeFromJSONSingle((JSONSingle)jsonObject);
            return o;
        }
        throw new RuntimeException("illegal syntax.");
    }

    protected abstract T decodeFromString(String var1);
}

