/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder.single.fixed;

import org.jtester.json.decoder.single.FixedTypeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatDecoder
extends FixedTypeDecoder<Float> {
    public static final FloatDecoder instance = new FloatDecoder();

    private FloatDecoder() {
        super(Float.class);
    }

    @Override
    protected Float decodeFromString(String value) {
        try {
            value = value.trim();
            if (value.endsWith("f") || value.endsWith("F")) {
                value = value.substring(0, value.length() - 1);
            }
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (Exception e) {
            String message = String.format("the value{%s} can't be casted to float number.", value);
            throw new RuntimeException(message, e);
        }
    }
}

