/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder.single.fixed;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jtester.json.decoder.single.FixedTypeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressDecoder
extends FixedTypeDecoder<InetAddress> {
    public static InetAddressDecoder instance = new InetAddressDecoder();

    private InetAddressDecoder() {
        super(InetAddress.class);
    }

    @Override
    protected InetAddress decodeFromString(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            String message = "can't cast value[" + host + "] to InetAddress.";
            throw new RuntimeException(message, e);
        }
    }
}

