/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder.single.fixed;

import org.jtester.json.decoder.single.FixedTypeDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongDecoder
extends FixedTypeDecoder<Long> {
    public static final LongDecoder instance = new LongDecoder();

    private LongDecoder() {
        super(Long.class);
    }

    @Override
    protected Long decodeFromString(String value) {
        try {
            value = value.trim();
            if (value.endsWith("l") || value.endsWith("L")) {
                value = value.substring(0, value.length() - 1);
            }
            return Long.parseLong(value);
        }
        catch (Exception e) {
            String message = String.format("the value{%s} can't be casted to long number.", value);
            throw new RuntimeException(message, e);
        }
    }
}

