/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.decoder.single.spec;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.json.decoder.single.SpecTypeDecoder;
import org.jtester.json.helper.JSONSingle;
import org.jtester.utility.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateDecoder<T extends Date>
extends SpecTypeDecoder<Date, T> {
    private static String dateFormat = null;

    public DateDecoder(Class clazz) {
        super(clazz);
    }

    protected Date decodeSimpleValue(JSONSingle simple) {
        String value = simple.toStringValue();
        if (value == null) {
            return null;
        }
        Date date = (Date)ClazzHelper.newInstance(this.clazz);
        long time = DateDecoder.getTime(value);
        date.setTime(time);
        return date;
    }

    @Override
    protected void setTargetValue(Date target, String value) {
        long time = DateDecoder.getTime(value);
        target.setTime(time);
    }

    @Override
    protected Date getDefaultInstance() {
        return new Date();
    }

    private static long getTime(String value) {
        if (value.matches("\\d+[Ll]?")) {
            long time = Long.valueOf(value.replaceAll("[Ll]", ""));
            return time;
        }
        if (dateFormat == null) {
            Date date = DateUtil.parse(value);
            return date.getTime();
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            Date date = df.parse(value);
            return date.getTime();
        }
        catch (ParseException e) {
            String message = "";
            throw new RuntimeException(message, e);
        }
    }

    public static void setDateFormat(String format) {
        dateFormat = format;
    }
}

