/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JSONException;
import org.jtester.json.encoder.JSONEncoder;
import org.jtester.json.encoder.PropertyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldEncoder
extends PropertyEncoder {
    private final Field field;
    private final String fieldName;
    private final Object value;

    public FieldEncoder(Field field, Object target, int features) {
        super(features);
        this.field = field;
        this.fieldName = this.field.getName();
        this.value = FieldHelper.getFieldValue(target, field);
    }

    @Override
    public void encodeKey(Writer writer, List<String> references) throws Exception {
        this.writerSpecProperty(this.fieldName, writer);
    }

    @Override
    public void encodeValue(Writer writer, List<String> references) throws IOException {
        boolean isNullOrRef = this.writerNullOrReference(this.value, writer, references, false);
        if (isNullOrRef) {
            return;
        }
        Class objType = ClazzHelper.getUnProxyType(this.value.getClass());
        JSONEncoder encoder = JSONEncoder.get(objType);
        encoder.setFeatures(this.features);
        if (this.doesIgnoreExplicitFieldType(this.field.getType(), objType)) {
            encoder.setUnMarkClassFlag(true);
        }
        try {
            encoder.encode(this.value, writer, references);
        }
        catch (Exception e) {
            throw new JSONException("encode field[" + this.fieldName + "] error.", e);
        }
    }

    private boolean doesIgnoreExplicitFieldType(Class fieldType, Class objectType) {
        if (!this.ignoreExplicitFieldType) {
            return false;
        }
        if (this.field.getType() == objectType) {
            return true;
        }
        return fieldType.isPrimitive();
    }

    @Override
    public boolean doesSkipNull() {
        return this.skipNullField && this.value == null;
    }
}

