/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JSONException;
import org.jtester.json.encoder.array.ArraysEncoder;
import org.jtester.json.encoder.array.CollectionEncoder;
import org.jtester.json.encoder.object.MapEncoder;
import org.jtester.json.encoder.object.PoJoEncoder;
import org.jtester.json.encoder.single.FixedTypeEncoder;
import org.jtester.json.encoder.single.SpecTypeEncoder;
import org.jtester.json.helper.ClazzMap;
import org.jtester.json.helper.JSONFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONEncoder<T> {
    protected int features;
    protected Class clazz;
    protected char quote_Char = (char)34;
    protected boolean unMarkClassFlag = false;
    protected boolean ignoreExplicitFieldType = false;
    protected boolean skipNullField = false;

    public JSONEncoder(Class clazz) {
        this.clazz = ClazzHelper.getUnProxyType(clazz);
    }

    public void setFeatures(int features) {
        this.features = features;
        boolean single = JSONFeature.isEnabled(features, JSONFeature.UseSingleQuote);
        this.quote_Char = (char)(single ? 39 : 34);
        this.unMarkClassFlag = JSONFeature.isEnabled(features, JSONFeature.UnMarkClassFlag);
        this.ignoreExplicitFieldType = JSONFeature.isEnabled(features, JSONFeature.IgnoreExplicitFieldType);
        this.skipNullField = JSONFeature.isEnabled(features, JSONFeature.SkipNullValue);
    }

    public void setUnMarkClassFlag(boolean unMarkClassFlag) {
        this.unMarkClassFlag = unMarkClassFlag;
    }

    public void setFeatures(JSONFeature ... jsonFeatures) {
        int features = JSONFeature.getFeaturesMask(jsonFeatures);
        this.setFeatures(features);
    }

    public abstract boolean encode(T var1, Writer var2, List<String> var3);

    public static JSONEncoder get(Class clazz) {
        FixedTypeEncoder finalTypeDecoder = FixedTypeEncoder.isFinalTypeEncoder(clazz);
        if (finalTypeDecoder != null) {
            return finalTypeDecoder;
        }
        SpecTypeEncoder specTypeEncoder = SpecTypeEncoder.isSpecTypeEncoder(clazz);
        if (specTypeEncoder != null) {
            return specTypeEncoder;
        }
        if (clazz.isArray()) {
            return ArraysEncoder.newInstance(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionEncoder(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapEncoder(clazz);
        }
        return new PoJoEncoder(clazz);
    }

    protected boolean writerNullOrReference(Object value, Writer writer, List<String> references, boolean isMarkRef) throws IOException {
        if (value == null) {
            boolean skipNull = JSONFeature.isEnabled(this.features, JSONFeature.SkipNullValue);
            if (!skipNull) {
                writer.append("null");
            }
            return true;
        }
        if (value instanceof Proxy) {
            writer.append("null");
            return true;
        }
        String address = ClazzMap.getReferenceAddress(value);
        if (references.contains(address)) {
            if (this.unMarkClassFlag) {
                writer.append("null");
            } else {
                writer.append('{');
                this.writerSpecProperty("#refer", writer);
                writer.append(':');
                writer.append(address);
                writer.append('}');
            }
            return true;
        }
        if (isMarkRef) {
            references.add(address);
        }
        return false;
    }

    protected void writerSpecProperty(String name, Writer writer) throws IOException {
        boolean quote = JSONFeature.isEnabled(this.features, JSONFeature.QuoteAllItems);
        if (!quote) {
            writer.append(name);
        } else {
            writer.append(this.quote_Char).append(name).append(this.quote_Char);
        }
    }

    protected boolean writeClassFlag(T target, Writer writer) throws IOException {
        if (target == null) {
            return false;
        }
        if (this.unMarkClassFlag) {
            return false;
        }
        String clazzname = ClazzMap.getClazzName(target);
        this.writerSpecProperty("#class", writer);
        writer.append(':');
        writer.append(this.quote_Char).append(clazzname).append(this.quote_Char);
        return true;
    }

    protected RuntimeException wrapException(Throwable e) {
        if (e instanceof Exception) {
            return (RuntimeException)e;
        }
        return new JSONException(e);
    }
}

