/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jtester.exception.JSONException;
import org.jtester.json.encoder.JSONEncoder;
import org.jtester.json.encoder.PropertyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapEntryEncoder
extends PropertyEncoder {
    private final Object key;
    private final Object value;

    public MapEntryEncoder(Object key, Object value, int features) {
        super(features);
        this.key = key;
        this.value = value;
    }

    @Override
    public void encodeKey(Writer writer, List<String> references) throws Exception {
        boolean isRef = this.writerNullOrReference(this.key, writer, references, false);
        if (isRef) {
            return;
        }
        Class<?> type = this.key.getClass();
        JSONEncoder encoder = JSONEncoder.get(type);
        encoder.setFeatures(this.features);
        try {
            encoder.encode(this.key, writer, references);
        }
        catch (Exception e) {
            throw new JSONException("encode map key error.", e);
        }
    }

    @Override
    public void encodeValue(Writer writer, List<String> references) throws IOException {
        boolean isNullOrRef = this.writerNullOrReference(this.value, writer, references, false);
        if (isNullOrRef) {
            return;
        }
        Class<?> type = this.value.getClass();
        JSONEncoder encoder = JSONEncoder.get(type);
        encoder.setFeatures(this.features);
        try {
            encoder.encode(this.value, writer, references);
        }
        catch (Exception e) {
            throw new JSONException("encode map value error.", e);
        }
    }

    @Override
    public boolean doesSkipNull() {
        return false;
    }
}

