/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.jtester.json.encoder.JSONEncoder;
import org.jtester.json.encoder.PropertyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectEncoder<T>
extends JSONEncoder<T> {
    protected ObjectEncoder(Class clazz) {
        super(clazz);
    }

    @Override
    public boolean encode(T target, Writer writer, List<String> references) {
        try {
            return this.encodeObject(target, writer, references);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private final boolean encodeObject(T target, Writer writer, List<String> references) throws Exception {
        boolean isNullOrRef = this.writerNullOrReference(target, writer, references, true);
        if (isNullOrRef) {
            return false;
        }
        Collection<PropertyEncoder> encoders = this.getPropertyEncoders(target);
        writer.write("{");
        boolean comma = this.writeClassFlag(target, writer);
        for (PropertyEncoder encoder : encoders) {
            if (encoder.doesSkipNull()) continue;
            if (comma) {
                writer.write(",");
            } else {
                comma = true;
            }
            comma = encoder.encode((Object)target, writer, references);
        }
        writer.write("}");
        return true;
    }

    protected abstract Collection<PropertyEncoder> getPropertyEncoders(T var1);
}

