/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder;

import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import org.jtester.json.encoder.FieldEncoder;
import org.jtester.json.encoder.JSONEncoder;
import org.jtester.json.encoder.MapEntryEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEncoder
extends JSONEncoder<Object> {
    protected PropertyEncoder(int features) {
        super(Object.class);
        this.setFeatures(features);
    }

    protected abstract void encodeKey(Writer var1, List<String> var2) throws Exception;

    protected abstract void encodeValue(Writer var1, List<String> var2) throws Exception;

    @Override
    public final boolean encode(Object target, Writer writer, List<String> references) {
        if (this.doesSkipNull()) {
            return false;
        }
        try {
            this.encodeKey(writer, references);
            writer.write(":");
            this.encodeValue(writer, references);
            return true;
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    public static PropertyEncoder newInstance(Field field, Object target, int features) {
        return new FieldEncoder(field, target, features);
    }

    public static PropertyEncoder newInstance(Object key, Object value, int features) {
        return new MapEntryEncoder(key, value, features);
    }

    public abstract boolean doesSkipNull();
}

