/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder.object;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.json.encoder.ObjectEncoder;
import org.jtester.json.encoder.PropertyEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoJoEncoder
extends ObjectEncoder {
    public static final List<String> filterFields = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("serialVersionUID");
            this.add("class");
        }
    };

    public PoJoEncoder(Class clazz) {
        super(clazz == Object.class ? HashMap.class : clazz);
    }

    protected Collection<PropertyEncoder> getPropertyEncoders(Object target) {
        ArrayList<PropertyEncoder> list = new ArrayList<PropertyEncoder>();
        if (target == null) {
            return list;
        }
        Class type = target.getClass();
        type = ClazzHelper.getUnProxyType(type);
        List<Field> fields = ClazzHelper.getAllFields(type, filterFields, false, true, false);
        for (Field field : fields) {
            if (this.skipFilterField(field.getName())) continue;
            PropertyEncoder encoder = PropertyEncoder.newInstance(field, target, this.features);
            encoder.setFeatures(this.features);
            list.add(encoder);
        }
        return list;
    }

    private boolean skipFilterField(String fieldname) {
        if (fieldname.startsWith("this$")) {
            return true;
        }
        return filterFields.contains(fieldname);
    }
}

