/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder.single;

import java.io.Writer;
import java.util.List;
import org.jtester.json.encoder.SingleEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecTypeEncoder<T>
extends SingleEncoder<T> {
    protected SpecTypeEncoder(Class clazz) {
        super(clazz);
    }

    @Override
    public final boolean encode(T target, Writer writer, List<String> references) {
        try {
            return this.encodeSpecType(target, writer, references);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private final boolean encodeSpecType(T target, Writer writer, List<String> references) throws Exception {
        boolean isNullOrRef = this.writerNullOrReference(target, writer, references, true);
        if (isNullOrRef) {
            return false;
        }
        Class<?> type = target.getClass();
        if (type == this.clazz) {
            if (this.unMarkClassFlag) {
                this.encodeSingleValue(target, writer);
            } else {
                writer.append("{");
                this.writeClassFlag(target, writer);
                writer.append(',');
                this.writerSpecProperty("#value", writer);
                writer.append(':');
                this.encodeSingleValue(target, writer);
                writer.append('}');
            }
        } else {
            writer.append("{");
            if (!this.unMarkClassFlag) {
                this.writeClassFlag(target, writer);
                writer.append(',');
            }
            this.writerSpecProperty("#value", writer);
            writer.append(':');
            this.encodeSingleValue(target, writer);
            this.encodeOtherProperty(target, writer);
            writer.append('}');
        }
        return true;
    }

    protected abstract void encodeSingleValue(T var1, Writer var2) throws Exception;

    protected abstract void encodeOtherProperty(T var1, Writer var2) throws Exception;
}

