/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder.single.fixed;

import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jtester.json.encoder.single.FixedTypeEncoder;
import org.jtester.json.encoder.single.fixed.StringEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketAddressEncoder
extends FixedTypeEncoder<InetSocketAddress> {
    public static SocketAddressEncoder instance = new SocketAddressEncoder();

    private SocketAddressEncoder() {
        super(InetSocketAddress.class);
    }

    @Override
    protected void encodeSingleValue(InetSocketAddress target, Writer writer) throws Exception {
        InetAddress address = target.getAddress();
        int port = target.getPort();
        String host = address == null ? "localhost" : address.getHostAddress();
        writer.append(this.quote_Char);
        StringEncoder.writeEscapeString(host, writer);
        writer.append(':');
        writer.append(String.valueOf(port));
        writer.append(this.quote_Char);
    }
}

