/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder.single.fixed;

import java.io.IOException;
import java.io.Writer;
import org.jtester.json.encoder.single.FixedTypeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEncoder
extends FixedTypeEncoder<String> {
    public static StringEncoder instance = new StringEncoder();
    static final char Anti_Slash = '\\';

    private StringEncoder() {
        super(String.class);
    }

    @Override
    public void encodeSingleValue(String target, Writer writer) throws Exception {
        writer.append(this.quote_Char);
        StringEncoder.writeEscapeString(target, writer);
        writer.append(this.quote_Char);
    }

    public static void writeEscapeString(String value, Writer writer) throws IOException {
        char[] chars;
        for (char ch : chars = value.toCharArray()) {
            StringEncoder.writerChar(ch, writer);
        }
    }

    public static void writerChar(char ch, Writer writer) throws IOException {
        switch (ch) {
            case '\"': {
                writer.append('\\').append('\"');
                return;
            }
            case '\'': {
                writer.append('\\').append('\'');
                return;
            }
            case '\\': {
                writer.append('\\').append('\\');
                return;
            }
            case '\b': {
                writer.append('\\').append('b');
                return;
            }
            case '\f': {
                writer.append('\\').append('f');
                return;
            }
            case '\n': {
                writer.append('\\').append('n');
                return;
            }
            case '\r': {
                writer.append('\\').append('r');
                return;
            }
            case '\t': {
                writer.append('\\').append('t');
                return;
            }
        }
        writer.append(ch);
    }
}

