/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.encoder.single.spec;

import java.io.Writer;
import java.util.Date;
import org.jtester.json.encoder.single.SpecTypeEncoder;
import org.jtester.json.encoder.single.fixed.StringEncoder;
import org.jtester.utility.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateEncoder<T extends Date>
extends SpecTypeEncoder<T> {
    public static DateEncoder instance = new DateEncoder();
    private static String dateFormat = null;

    private DateEncoder() {
        super(Date.class);
    }

    @Override
    protected void encodeSingleValue(T target, Writer writer) throws Exception {
        String df = dateFormat == null ? "yyyy-MM-dd HH:mm:ss" : dateFormat;
        String date = DateUtil.toDateTimeStr(target, df);
        writer.append(this.quote_Char);
        StringEncoder.writeEscapeString(date, writer);
        writer.append(this.quote_Char);
    }

    @Override
    protected void encodeOtherProperty(T target, Writer writer) throws Exception {
    }

    public static void setDateFormat(String format) {
        dateFormat = format;
    }
}

