/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.helper;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Pattern;
import org.jtester.bytecode.reflector.helper.ClazzHelper;

public final class ClazzMap {
    static Map<Class, String> alias = new HashMap<Class, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Boolean.class, "Boolean");
            this.put(Boolean.TYPE, "boolean");
            this.put(Boolean[].class, "Boolean[]");
            this.put(boolean[].class, "boolean[]");
            this.put(Byte.class, "Byte");
            this.put(Byte.TYPE, "byte");
            this.put(Byte[].class, "Byte[]");
            this.put(byte[].class, "byte[]");
            this.put(Character.class, "Character");
            this.put(Character.TYPE, "char");
            this.put(Character[].class, "Character[]");
            this.put(char[].class, "char[]");
            this.put(Double.class, "Double");
            this.put(Double.TYPE, "double");
            this.put(Double[].class, "Double[]");
            this.put(double[].class, "double[]");
            this.put(Float.class, "Float");
            this.put(Float.TYPE, "float");
            this.put(Float[].class, "Float[]");
            this.put(float[].class, "float[]");
            this.put(Integer.class, "Integer");
            this.put(Integer.TYPE, "int");
            this.put(Integer[].class, "Integer[]");
            this.put(int[].class, "int[]");
            this.put(Long.class, "Long");
            this.put(Long.TYPE, "long");
            this.put(Long[].class, "Long[]");
            this.put(long[].class, "long[]");
            this.put(Short.class, "Short");
            this.put(Short.TYPE, "short");
            this.put(Short[].class, "Short[]");
            this.put(short[].class, "short[]");
            this.put(String.class, "string");
            this.put(String[].class, "string[]");
            this.put(HashMap.class, "map");
            this.put(ArrayList.class, "list");
            this.put(HashSet.class, "set");
            this.put(BigInteger.class, "BigInteger");
            this.put(BigDecimal.class, "BigDecimal");
            this.put(Charset.class, "Charset");
            this.put(Class.class, "class");
            this.put(Locale.class, "Locale");
            this.put(Pattern.class, "Pattern");
            this.put(TimeZone.class, "TimeZone");
            this.put(URI.class, "URI");
            this.put(URL.class, "URL");
            this.put(UUID.class, "UUID");
            this.put(File.class, "File");
            this.put(Date.class, "Date");
            this.put(SimpleDateFormat.class, "SimpleDateFormat");
            this.put(AtomicBoolean.class, "atomic.bool");
            this.put(AtomicInteger.class, "atomic.int");
            this.put(AtomicIntegerArray.class, "atomic.int[]");
            this.put(AtomicLong.class, "atomic.long");
            this.put(AtomicLongArray.class, "atomic.long[]");
            this.put(AtomicReference.class, "atomic.reference");
            this.put(AtomicReferenceArray.class, "atomic.reference[]");
        }
    };
    static List<Class> simples = new ArrayList<Class>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Boolean.class);
            this.add(Boolean.TYPE);
            this.add(Byte.class);
            this.add(Byte.TYPE);
            this.add(Character.class);
            this.add(Character.TYPE);
            this.add(Double.class);
            this.add(Double.TYPE);
            this.add(Float.class);
            this.add(Float.TYPE);
            this.add(Integer.class);
            this.add(Integer.TYPE);
            this.add(Long.class);
            this.add(Long.TYPE);
            this.add(Short.class);
            this.add(Short.TYPE);
            this.add(String.class);
            this.add(BigInteger.class);
            this.add(BigDecimal.class);
            this.add(Charset.class);
            this.add(Class.class);
            this.add(Locale.class);
            this.add(Pattern.class);
            this.add(TimeZone.class);
            this.add(URI.class);
            this.add(URL.class);
            this.add(UUID.class);
            this.add(File.class);
            this.add(Date.class);
            this.add(SimpleDateFormat.class);
            this.add(AtomicBoolean.class);
            this.add(AtomicInteger.class);
            this.add(AtomicIntegerArray.class);
            this.add(AtomicLong.class);
            this.add(AtomicLongArray.class);
            this.add(AtomicReference.class);
            this.add(AtomicReferenceArray.class);
        }
    };
    private static final Map<String, Class> existedClazz = new HashMap<String, Class>();

    public static String getClazzName(Object target) {
        Class clazz = ClazzHelper.getUnProxyType(target.getClass());
        String typename = clazz.getName();
        for (Class type : alias.keySet()) {
            if (type != clazz) continue;
            typename = alias.get(type);
            break;
        }
        if (simples.contains(clazz)) {
            return typename;
        }
        return typename + ClazzMap.getReferenceAddress(target);
    }

    public static Class getClazzType(String clazzname) {
        for (Map.Entry<Class, String> entry : alias.entrySet()) {
            String typename = entry.getValue();
            if (!typename.equals(clazzname)) continue;
            return entry.getKey();
        }
        if (existedClazz.containsKey(clazzname)) {
            return existedClazz.get(clazzname);
        }
        Class clazz = ClazzHelper.getClazz(clazzname);
        existedClazz.put(clazzname, clazz);
        return clazz;
    }

    public static final String getReferenceAddress(Object o) {
        assert (o != null) : "the object value can't be null.";
        Class type = ClazzHelper.getUnProxyType(o.getClass());
        if (simples.contains(type)) {
            return null;
        }
        try {
            return "@" + Integer.toHexString(o.hashCode());
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

