/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.helper;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JSONFeature {
    UnMarkClassFlag,
    QuoteAllItems,
    UseSingleQuote,
    SkipNullValue,
    IgnoreExplicitFieldType;

    private final int mask = 1 << this.ordinal();
    public static final String ClazzFlag = "#class";
    public static final String ValueFlag = "#value";
    public static final String ReferFlag = "#refer";
    public static final String ErrroFlag = "#error";

    public final int getMask() {
        return this.mask;
    }

    public static boolean isEnabled(int features, JSONFeature feature) {
        return (features & feature.getMask()) != 0;
    }

    public static int getFeaturesMask(JSONFeature ... features) {
        int marks = 0;
        for (JSONFeature feature : features) {
            int mark = feature.mask;
            marks |= mark;
        }
        return marks;
    }

    public static List<JSONFeature> getSerializerFeatures(int features) {
        JSONFeature[] values = JSONFeature.values();
        ArrayList<JSONFeature> list = new ArrayList<JSONFeature>();
        for (JSONFeature value : values) {
            boolean isEnabled = JSONFeature.isEnabled(features, value);
            if (!isEnabled) continue;
            list.add(value);
        }
        return list;
    }
}

