/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.helper;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jtester.exception.JSONException;
import org.jtester.json.helper.ClazzMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONSingle;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMap
extends LinkedHashMap<JSONObject, JSONObject>
implements JSONObject {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private String referenceID = null;

    public JSONMap() {
        super(16);
    }

    public JSONMap(int size) {
        super(size);
    }

    public JSONMap(Map<JSONObject, JSONObject> map) {
        super(map);
    }

    @Override
    public boolean containsKey(Object key) {
        JSONObject newkey = JSONSingle.convertJSON(key);
        return super.containsKey(newkey);
    }

    @Override
    public JSONObject get(Object key) {
        JSONObject newkey = JSONSingle.convertJSON(key);
        return (JSONObject)super.get(newkey);
    }

    public JSONObject putJSON(Object key, Object value) {
        JSONObject newkey = JSONSingle.convertJSON(key);
        JSONObject newValue = JSONSingle.convertJSON(value);
        return super.put(newkey, newValue);
    }

    public String getReferenceID() {
        return this.referenceID;
    }

    public Class getClazzFromJSONFProp(Class defaultClazz) {
        JSONObject object = this.get(JSON_ClazzFlag);
        if (object == null) {
            return defaultClazz;
        }
        if (!(object instanceof JSONSingle)) {
            throw new JSONException("the class flag value can only be JSONSingle type.");
        }
        JSONSingle value = (JSONSingle)object;
        String clazzName = value.toClazzName();
        if (StringHelper.isBlankOrNull(clazzName)) {
            this.referenceID = null;
            return defaultClazz;
        }
        Class clazz = ClazzMap.getClazzType(clazzName.trim());
        this.referenceID = value.toReferenceID();
        return clazz == null ? defaultClazz : clazz;
    }

    public JSONObject getValueFromJSONProp() {
        JSONObject value = this.get(JSON_ValueFlag);
        return value;
    }

    public String getReferFromJSONProp() {
        JSONSingle object = (JSONSingle)this.get(JSON_ReferFlag);
        if (object == null) {
            return null;
        }
        if (!(object instanceof JSONSingle)) {
            throw new JSONException("the object reference value can only be JSONSingle type.");
        }
        JSONSingle value = object;
        String referenceID = value.toStringValue();
        return referenceID;
    }

    @Override
    public String description() {
        return this.toString();
    }
}

