/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.json.helper;

import org.jtester.exception.JSONException;
import org.jtester.json.helper.JSONArray;
import org.jtester.json.helper.JSONMap;
import org.jtester.json.helper.JSONObject;
import org.jtester.json.helper.JSONSingle;
import org.jtester.json.helper.SymbolBuff;
import org.jtester.utility.StringHelper;

public class JSONScanner {
    private final char[] input;
    private final int length;
    private int index = 0;
    private SymbolBuff symbolBuff = new SymbolBuff();
    private static boolean[] singleValueFlags;

    public static JSONObject scnJSON(String json) {
        if (StringHelper.isBlankOrNull(json)) {
            return null;
        }
        char[] input = json.toCharArray();
        JSONScanner scanner = new JSONScanner(input);
        JSONObject o = scanner.scan();
        return o;
    }

    JSONScanner(char[] input) {
        this.length = input.length;
        this.input = new char[this.length + 1];
        System.arraycopy(input, 0, this.input, 0, this.length);
        this.input[this.length] = '\u0000';
    }

    public JSONObject scan() {
        JSONObject json = null;
        char ch = this.nextToken();
        switch (ch) {
            case '{': {
                json = this.scanJSONMap();
                break;
            }
            case '[': {
                json = this.scanJSONArray();
                break;
            }
            default: {
                --this.index;
                json = this.scanJSONValue();
            }
        }
        ch = this.nextToken();
        if (ch != '\u0000' || this.index != this.length + 1) {
            throw this.syntaxError("syntax error.");
        }
        return json;
    }

    JSONMap scanJSONMap() {
        JSONMap map = new JSONMap();
        char ch = this.nextToken();
        --this.index;
        while (ch != '}') {
            JSONObject key = this.scanMapKey();
            ch = this.nextToken();
            if (ch != ':') {
                throw this.syntaxError("syntax error, expected char ':'.");
            }
            JSONObject value = this.scanMapValue();
            map.put(key, value);
            ch = this.nextToken();
            if (ch == ',' || ch == '}') continue;
            throw this.syntaxError("syntax error, expected char '}' or ','.");
        }
        return map;
    }

    JSONArray scanJSONArray() {
        JSONArray array = new JSONArray();
        char ch = this.nextToken();
        while (ch != ']') {
            JSONObject json = null;
            switch (ch) {
                case '{': {
                    json = this.scanJSONMap();
                    break;
                }
                case '[': {
                    json = this.scanJSONArray();
                    break;
                }
                case '\'': {
                    json = this.scanString('\'', new char[0]);
                    break;
                }
                case '\"': {
                    json = this.scanString('\"', new char[0]);
                    break;
                }
                default: {
                    --this.index;
                    json = this.scanString(',', ']', '\u0000');
                    --this.index;
                }
            }
            array.add(json);
            ch = this.nextToken();
            if (ch != ',' && ch != ']') {
                throw this.syntaxError("syntax error, expectd char ',' or ']'.");
            }
            if (ch != ',') continue;
            ch = this.nextToken();
        }
        return array;
    }

    JSONSingle scanJSONValue() {
        JSONSingle json = null;
        char ch = this.nextToken();
        switch (ch) {
            case '\'': {
                json = this.scanString('\'', new char[0]);
                break;
            }
            case '\"': {
                json = this.scanString('\"', new char[0]);
                break;
            }
            default: {
                --this.index;
                json = this.scanString('\u0000', new char[0]);
                --this.index;
            }
        }
        return json;
    }

    JSONObject scanMapKey() {
        char ch = this.nextToken();
        JSONObject json = null;
        switch (ch) {
            case '\u0000': {
                throw this.syntaxError("syntax error.");
            }
            case '{': {
                json = this.scanJSONMap();
                break;
            }
            case '[': {
                json = this.scanJSONArray();
                break;
            }
            case '\"': {
                json = this.scanString('\"', new char[0]);
                break;
            }
            case '\'': {
                json = this.scanString('\'', new char[0]);
                break;
            }
            default: {
                --this.index;
                json = this.scanString(':', new char[0]);
                --this.index;
            }
        }
        return json;
    }

    JSONObject scanMapValue() {
        char ch = this.nextToken();
        JSONObject json = null;
        switch (ch) {
            case '\u0000': {
                throw this.syntaxError("syntax error");
            }
            case '{': {
                json = this.scanJSONMap();
                break;
            }
            case '[': {
                json = this.scanJSONArray();
                break;
            }
            case '\"': {
                json = this.scanString('\"', new char[0]);
                break;
            }
            case '\'': {
                json = this.scanString('\'', new char[0]);
                break;
            }
            default: {
                --this.index;
                json = this.scanString(',', '}', ']');
                --this.index;
            }
        }
        return json;
    }

    private final JSONSingle scanString(char endChar, char ... endChars) {
        JSONSingle json = new JSONSingle(endChar == '\'' || endChar == '\"');
        json.setBeginIndex(this.index);
        char ch = this.input[this.index++];
        while (ch != endChar && !JSONScanner.contain(endChars, ch)) {
            if (ch == '\u0000') {
                throw this.syntaxError("syntax error.");
            }
            if (ch == '\\') {
                ch = this.getEscapedChar();
                this.symbolBuff.append(ch);
            } else {
                this.symbolBuff.append(ch);
            }
            ch = this.input[this.index++];
        }
        String symbol = this.symbolBuff.getSymbol();
        json.setValue(symbol);
        json.setEndIndex(this.index);
        return json;
    }

    private static boolean contain(char[] chars, char ch) {
        if (chars.length == 0 || chars == null) {
            return false;
        }
        for (char c : chars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    private char getEscapedChar() {
        char ch = this.input[this.index++];
        switch (ch) {
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
            case '/': {
                return '/';
            }
            case 'b': {
                return 'b';
            }
            case 'F': 
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                char u1 = this.input[this.index++];
                char u2 = this.input[this.index++];
                char u3 = this.input[this.index++];
                char u4 = this.input[this.index++];
                int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                return (char)val;
            }
        }
        throw this.syntaxError("syntax error.");
    }

    char nextToken() {
        if (this.index > this.length) {
            throw this.syntaxError("syntax error end.");
        }
        this.skipWhitespace();
        char ch = this.input[this.index];
        ++this.index;
        return ch;
    }

    final int skipWhitespace() {
        char ch = this.input[this.index];
        while (StringHelper.isSpace(ch)) {
            ++this.index;
            ch = this.input[this.index];
        }
        return this.index;
    }

    private JSONException syntaxError(String message) {
        StringBuffer error = new StringBuffer(message);
        error.append("\n syntax error at position:" + this.index);
        error.append("\n string parsed is:\n");
        error.append(new String(this.input, 0, this.index));
        return new JSONException(error.toString());
    }

    static {
        int ch;
        singleValueFlags = new boolean[256];
        for (ch = 48; ch <= 57; ch = (int)((char)(ch + 1))) {
            JSONScanner.singleValueFlags[ch] = true;
        }
        for (ch = 97; ch <= 122; ch = (int)((char)(ch + 1))) {
            JSONScanner.singleValueFlags[ch] = true;
        }
        for (ch = 65; ch <= 90; ch = (int)((char)(ch + 1))) {
            JSONScanner.singleValueFlags[ch] = true;
        }
        JSONScanner.singleValueFlags[45] = true;
        JSONScanner.singleValueFlags[43] = true;
        JSONScanner.singleValueFlags[46] = true;
        JSONScanner.singleValueFlags[58] = true;
    }
}

