/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core;

import java.lang.reflect.Method;
import java.util.List;
import org.jtester.core.TestedObject;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.core.helper.ModulesManager;
import org.jtester.module.core.loader.ConfigurationLoader;
import org.jtester.module.core.loader.ModulesLoader;
import org.jtester.utility.JTesterLogger;

public class CoreModule {
    private static CoreModule instance;
    private TestListener testListener;

    public static synchronized CoreModule getInstance() {
        if (instance == null) {
            CoreModule.initSingletonInstance();
        }
        return instance;
    }

    public static void initSingletonInstance() {
        ConfigurationLoader.loading();
        JTesterLogger.level = ConfigurationHelper.logLevel();
        instance = new CoreModule();
    }

    public CoreModule() {
        List<Module> modules = ModulesLoader.loading();
        this.testListener = new CoreModuleListener();
        for (Module module : modules) {
            module.afterInit();
        }
    }

    public static TestListener getTestListener() {
        return CoreModule.getInstance().testListener;
    }

    private class CoreModuleListener
    extends TestListener {
        private CoreModuleListener() {
        }

        public void setupClass(Class testClazz) {
            JTesterLogger.resetLog4jLevel();
            TestedObject.setContext(testClazz);
            List<TestListener> listeners = ModulesManager.getTestListeners();
            for (TestListener listener : listeners) {
                listener.setupClass(testClazz);
            }
        }

        public void setupMethod(Object testObject, Method testMethod) {
            TestedObject.setContext(testObject, testMethod);
            List<TestListener> listeners = ModulesManager.getTestListeners();
            for (TestListener listener : listeners) {
                listener.setupMethod(testObject, testMethod);
            }
        }

        public void beforeMethodRunning(Object testObject, Method testMethod) {
            TestedObject.setContext(testObject, testMethod);
            List<TestListener> listeners = ModulesManager.getTestListeners();
            for (TestListener listener : listeners) {
                listener.beforeMethodRunning(testObject, testMethod);
            }
        }

        public void afterMethodRunned(Object testObject, Method testMethod, Throwable throwable) {
            TestedObject.setContext(testObject, testMethod);
            List<TestListener> listeners = ModulesManager.getTestListeners_Reverse();
            for (TestListener listener : listeners) {
                listener.afterMethodRunned(testObject, testMethod, throwable);
            }
        }

        public void teardownMethod(Object testObject, Method testMethod) {
            TestedObject.setContext(testObject, testMethod);
            List<TestListener> listeners = ModulesManager.getTestListeners_Reverse();
            for (TestListener listener : listeners) {
                listener.teardownMethod(testObject, testMethod);
            }
        }

        public void teardownClass(Object testObject) {
            List<TestListener> listeners = ModulesManager.getTestListeners_Reverse();
            for (TestListener listener : listeners) {
                listener.teardownClass(testObject);
            }
            TestedObject.cleanContext();
        }

        protected String getName() {
            return "CoreModuleListener";
        }
    }
}

