/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.jtester.core.TestedObject;
import org.jtester.core.context.TransactionManager;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.support.DefaultSQLHandler;
import org.jtester.module.database.util.ConstraintsDisabler;
import org.jtester.utility.JTesterLogger;
import org.springframework.transaction.PlatformTransactionManager;

public class DatabaseModule
implements Module {
    public static final String PROPERTY_UPDATEDATABASESCHEMA_ENABLED = "updateDataBaseSchema.enabled";
    protected static boolean hasExetedDisabled = false;

    public void init() {
        JTesterLogger.info("PlatformTransactionManager class init.");
        PlatformTransactionManager.class.getName();
    }

    public void afterInit() {
        boolean disabledConstraint = ConfigurationHelper.doesDisableConstraints();
        if (disabledConstraint) {
            this.disableConstraints();
        }
    }

    public void disableConstraints() {
        DataSource dataSource = DBEnvironmentFactory.getDBEnvironment().getDataSource(false);
        DefaultSQLHandler sqlHandler = new DefaultSQLHandler(dataSource);
        String databaseDialect = ConfigurationHelper.getString("database.dialect");
        ConstraintsDisabler disabler = ConfigurationHelper.getInstanceOf(ConstraintsDisabler.class, databaseDialect);
        disabler.init(sqlHandler);
        disabler.disableConstraints();
    }

    public TestListener getTestListener() {
        return new DatabaseTestListener();
    }

    protected class DatabaseTestListener
    extends TestListener {
        protected DatabaseTestListener() {
        }

        public void setupMethod(Object testObject, Method testMethod) {
            TestedObject.setLocalTransactionManager();
        }

        public void beforeMethodRunning(Object testObject, Method testMethod) {
            boolean isEnabledTransaction = TestedObject.isTransactionsEnabled();
            TransactionManager transaction = TestedObject.getLocalTransactionManager();
            if (isEnabledTransaction && transaction != null) {
                transaction.startTransaction();
            }
        }

        public void afterMethodRunned(Object testObject, Method testMethod, Throwable testThrowable) {
            boolean isEnabledTransaction = TestedObject.isTransactionsEnabled();
            TransactionManager transaction = TestedObject.getLocalTransactionManager();
            if (isEnabledTransaction && transaction != null) {
                transaction.endTransaction();
            }
        }

        public void teardownMethod(Object testObject, Method testMethod) {
            TestedObject.removeLocalTransactionManager();
        }

        protected String getName() {
            return "DatabaseTestListener";
        }
    }
}

