/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jtester.annotations.DbFit;
import org.jtester.annotations.FitVar;
import org.jtester.core.context.DbFitContext;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.util.SqlRunner;
import org.jtester.module.dbfit.AutoFindDbFit;
import org.jtester.module.dbfit.DbFitRunner;
import org.jtester.module.tracer.jdbc.JdbcTracerManager;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFitModule
implements Module {
    @Override
    public void init() {
        SymbolUtil.init();
    }

    @Override
    public void afterInit() {
    }

    public static void setSymbols(DbFit dbFit) {
        if (dbFit == null) {
            return;
        }
        Map<String, Object> symbols = DbFitModule.exactFitVars(dbFit);
        SymbolUtil.setSymbol(symbols);
    }

    private static Map<String, Object> exactFitVars(DbFit dbFit) {
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        if (dbFit == null) {
            return symbols;
        }
        FitVar[] vars = dbFit.vars();
        if (vars == null) {
            return symbols;
        }
        for (FitVar var : vars) {
            symbols.put(var.key(), var.value());
        }
        return symbols;
    }

    private static void runDbFiles(Class testClazz, String[] files) {
        if (files == null) {
            return;
        }
        DbFitContext.setRunIn(DbFitContext.RunIn.TestCase);
        for (String file : files) {
            if (file == null || "".equals(file.trim())) {
                throw new RuntimeException("@DbFit file name can't be null or emptry.");
            }
            if (file.endsWith(".wiki")) {
                DbFitRunner.runDbFit(testClazz, file, new String[0]);
                continue;
            }
            if (file.endsWith(".sql")) {
                SqlRunner.executeFromFile(testClazz, file);
                JTesterLogger.info(String.format("execute sql file[%s] successfully.", file));
                continue;
            }
            String error = String.format("@DbFit only support wiki file or sql file, please check the file[%s] format.", file);
            throw new RuntimeException(error);
        }
    }

    @Override
    public TestListener getTestListener() {
        return new DbFitTestListener();
    }

    protected class DbFitTestListener
    extends TestListener {
        protected DbFitTestListener() {
        }

        public void setupClass(Class testClazz) {
            DbFit dbFit = AnnotationUtils.getClassLevelAnnotation(DbFit.class, testClazz);
            if (dbFit == null) {
                return;
            }
            JdbcTracerManager.suspendThreadMonitorJdbc();
            DBEnvironmentFactory.changeDBEnvironment(dbFit.dataSource());
            DbFitModule.setSymbols(dbFit);
            String[] files = AutoFindDbFit.autoFindClassWhen(testClazz);
            DbFitModule.runDbFiles(testClazz, files);
            DBEnvironmentFactory.commitCurrentDBEnvironment();
            JdbcTracerManager.continueThreadMonitorJdbc();
        }

        public void beforeMethodRunning(Object testObject, Method testMethod) {
            Class<?> testedClazz = testObject.getClass();
            JdbcTracerManager.suspendThreadMonitorJdbc();
            DbFit dbFit = testMethod.getAnnotation(DbFit.class);
            if (dbFit != null) {
                DBEnvironmentFactory.changeDBEnvironment(dbFit.dataSource());
                DbFitModule.setSymbols(dbFit);
            }
            String[] files = AutoFindDbFit.autoFindMethodWhen(testedClazz, testMethod);
            DbFitModule.runDbFiles(testedClazz, files);
            JdbcTracerManager.continueThreadMonitorJdbc();
        }

        public void afterMethodRunned(Object testObject, Method testMethod, Throwable testThrowable) {
            Class<?> testedClazz = testObject.getClass();
            JdbcTracerManager.suspendThreadMonitorJdbc();
            DbFit dbFit = testMethod.getAnnotation(DbFit.class);
            if (dbFit != null) {
                DBEnvironmentFactory.changeDBEnvironment(dbFit.dataSource());
                DbFitModule.setSymbols(dbFit);
            }
            String[] files = AutoFindDbFit.autoFindMethodThen(testedClazz, testMethod);
            DbFitModule.runDbFiles(testedClazz, files);
            SymbolUtil.cleanSymbols();
            DBEnvironmentFactory.changeDBEnvironment("DEFAULT");
            JdbcTracerManager.continueThreadMonitorJdbc();
        }

        protected String getName() {
            return "DbFitTestListener";
        }
    }
}

