/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.jtester.annotations.Inject;
import org.jtester.bytecode.imposteriser.JTesterProxy;
import org.jtester.bytecode.reflector.PropertyAccessor;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.InjectionModuleHelper;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.StringHelper;

public class InjectModule
implements Module {
    public void init() {
    }

    public void afterInit() {
    }

    private void jtesterInject(Object testedObject) {
        Set<Field> injects = AnnotationUtils.getFieldsAnnotatedWith(testedObject.getClass(), Inject.class);
        for (Field injectField : injects) {
            Class<?> injectedClazz = injectField.getType();
            Inject inject = injectField.getAnnotation(Inject.class);
            Object injectedObject = JTesterProxy.proxy(testedObject.getClass(), injectField);
            InjectModule.injectedInto(testedObject, injectedObject, injectedClazz, inject.targets(), inject.properties());
        }
    }

    private static void injectedInto(Object testedObject, Object injectedObject, Class injectedClazz, String[] targets, String[] properties) {
        for (int index = 0; index < targets.length; ++index) {
            String property;
            String target = targets[index];
            Object targetObject = PropertyAccessor.getPropertyByOgnl(testedObject, target, true);
            if ((targetObject = ClazzHelper.getProxiedObject(targetObject)) == null) {
                throw new RuntimeException("can't inject a mock object into a null object, ongl = " + target);
            }
            String string = property = index < properties.length ? properties[index] : null;
            if (StringHelper.isBlankOrNull(property)) {
                InjectionModuleHelper.injectIntoByType(injectedObject, injectedClazz == null ? targetObject.getClass() : injectedClazz, targetObject);
                continue;
            }
            InjectionModuleHelper.injectInto(injectedObject, targetObject, property);
        }
    }

    public TestListener getTestListener() {
        return new InjectTestListener();
    }

    protected class InjectTestListener
    extends TestListener {
        protected InjectTestListener() {
        }

        public void beforeMethodRunning(Object testObject, Method testMethod) {
            InjectModule.this.jtesterInject(testObject);
        }

        protected String getName() {
            return "InjectTestListener";
        }
    }
}

