/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core;

import java.lang.reflect.Method;
import org.jtester.core.TestedObject;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.core.helper.SpringModuleHelper;
import org.jtester.module.spring.ApplicationContextFactory;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.strategy.injector.SpringBeanInjector;

public class SpringModule
implements Module {
    private ApplicationContextFactory contextFactory;

    public void init() {
        this.contextFactory = (ApplicationContextFactory)ConfigurationHelper.getInstance("SpringModule.ApplicationContextFactory.ImplClassName");
    }

    public void afterInit() {
    }

    public void invalidateApplicationContext() {
        Class testClazz = TestedObject.currTestedClazz();
        TestedObject.removeSpringContext();
        JTesterBeanFactory beanFactory = SpringModuleHelper.initSpringContext(testClazz, this.contextFactory);
        TestedObject.setSpringContext(beanFactory);
    }

    public TestListener getTestListener() {
        return new SpringTestListener();
    }

    protected class SpringTestListener
    extends TestListener {
        protected SpringTestListener() {
        }

        public void setupClass(Class testClazz) {
            JTesterBeanFactory beanFactory = SpringModuleHelper.initSpringContext(testClazz, SpringModule.this.contextFactory);
            TestedObject.setSpringContext(beanFactory);
        }

        public void setupMethod(Object testObject, Method testMethod) {
            JTesterBeanFactory beanFactory = TestedObject.getSpringBeanFactory();
            if (beanFactory != null) {
                SpringBeanInjector.injectSpringBeans((Object)beanFactory, testObject);
            }
        }

        public void teardownClass(Object testedObject) {
            TestedObject.removeSpringContext();
        }

        protected String getName() {
            return "SpringTestListener";
        }
    }
}

