/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.ConfigurationConst;
import org.jtester.module.core.loader.ConfigurationLoader;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper
implements ConfigurationConst {
    public static final String PROPKEY_DATABASE_DIALECT = "database.dialect";
    private static Properties properties = null;

    public static Properties getConfiguration() {
        if (properties == null) {
            properties = ConfigurationLoader.loading();
        }
        return properties;
    }

    public static int logLevel() {
        String level = ConfigurationHelper.getString("log.level", "INFO");
        if ("DEBUG".equalsIgnoreCase(level)) {
            return 0;
        }
        if ("INFO".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("WARNING".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("ERROR".equalsIgnoreCase(level)) {
            return 3;
        }
        return 1;
    }

    public static String getString(String key) {
        String value = ConfigurationHelper.getConfiguration().getProperty(key);
        return value;
    }

    public static String getString(String key, String defaultValue) {
        String value = ConfigurationHelper.getConfiguration().getProperty(key);
        if (StringHelper.isBlankOrNull(value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static String getString(Properties properties, String key) {
        String value = ConfigurationHelper.getString(properties, key, "");
        if (StringHelper.isBlankOrNull(value)) {
            throw new JTesterException("No value found for property " + key);
        }
        return value.trim();
    }

    public static String getString(Properties properties, String key, String defaultValue) {
        String value = null;
        if (properties == null) {
            value = ConfigurationHelper.getConfiguration().getProperty(key);
        } else {
            value = properties.getProperty(key);
            if (StringHelper.isBlankOrNull(value)) {
                value = ConfigurationHelper.getConfiguration().getProperty(key);
            }
        }
        if (StringHelper.isBlankOrNull(value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static List<String> getStringList(String propertyName) {
        return ConfigurationHelper.getStringList(propertyName, false);
    }

    public static List<String> getStringList(String propertyName, boolean required) {
        String values = ConfigurationHelper.getString(propertyName);
        if (values == null || "".equals(values.trim())) {
            if (required) {
                throw new JTesterException("No value found for property " + propertyName);
            }
            return new ArrayList<String>(0);
        }
        String[] splitValues = values.split(",");
        ArrayList<String> result = new ArrayList<String>(splitValues.length);
        for (String value : splitValues) {
            result.add(value.trim());
        }
        if (required && result.isEmpty()) {
            throw new JTesterException("No value found for property " + propertyName);
        }
        return result;
    }

    public static boolean getBoolean(String key) {
        String prop = ConfigurationHelper.getConfiguration().getProperty(key);
        return "true".equalsIgnoreCase(prop);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = ConfigurationHelper.getConfiguration().getProperty(key);
        if (StringHelper.isBlankOrNull(value)) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(value);
    }

    public static int getInteger(String key, int defaultValue) {
        String prop = ConfigurationHelper.getConfiguration().getProperty(key);
        try {
            int i = Integer.valueOf(prop);
            return i;
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public static boolean hasProperty(String key) {
        String value = ConfigurationHelper.getString(key);
        return value != null;
    }

    public static <T> T getInstance(String clazNameProperty) {
        String className = ConfigurationHelper.getString(clazNameProperty);
        return ClazzHelper.createInstanceOfType(className);
    }

    public static <T> T getInstanceOf(Class<? extends T> type, String ... implementationDiscriminatorValues) {
        String implClassName = ConfigurationHelper.getConfiguredClassName(type, implementationDiscriminatorValues);
        JTesterLogger.debug("Creating instance of " + type + ". Implementation class " + implClassName);
        return ClazzHelper.createInstanceOfType(implClassName);
    }

    public static String databaseDriver() {
        return ConfigurationHelper.getConfiguration().getProperty("database.driverClassName");
    }

    public static String databaseUrl() {
        return ConfigurationHelper.getConfiguration().getProperty("database.url");
    }

    public static String databaseUserName() {
        return ConfigurationHelper.getConfiguration().getProperty("database.userName");
    }

    public static String databasePassword() {
        return ConfigurationHelper.getConfiguration().getProperty("database.password");
    }

    public static boolean doesDisableConstraints() {
        String disableConstraints = ConfigurationHelper.getConfiguration().getProperty("dbMaintainer.disableConstraints.enabled");
        return "TRUE".equalsIgnoreCase(disableConstraints);
    }

    public static boolean doesOnlyTestDatabase() {
        String onlytest = ConfigurationHelper.getConfiguration().getProperty("database.only.testdb.allowing");
        return !"FALSE".equalsIgnoreCase(onlytest);
    }

    public static boolean isSpringDataSourceName(String beanName) {
        String dataSourceName = ConfigurationHelper.getConfiguration().getProperty("SpringModule.DataSource.Name");
        return beanName.equals(dataSourceName) || beanName.equals("spring.datasource.name");
    }

    public static boolean autoExport() {
        String auto = ConfigurationHelper.getConfiguration().getProperty("dbexport.auto");
        return auto != null && auto.equalsIgnoreCase("true");
    }

    public static boolean isScript() {
        String script = ConfigurationHelper.getConfiguration().getProperty("dbexport.script");
        return script != null && script.equalsIgnoreCase("true");
    }

    public static String databaseType() {
        String type = System.getProperty("database.type");
        if (!StringHelper.isBlankOrNull(type)) {
            return type;
        }
        type = ConfigurationHelper.getConfiguration().getProperty("database.type");
        return type;
    }

    public static String dbfitDir() {
        String dir = ConfigurationHelper.getConfiguration().getProperty("dbfit.dir");
        return StringHelper.isBlankOrNull(dir) ? "target/dbfit" : dir;
    }

    public static void disableDbMaintain() {
        ConfigurationHelper.getConfiguration().setProperty("updateDataBaseSchema.enabled", "false");
        ConfigurationHelper.getConfiguration().setProperty("dbMaintainer.dbVersionSource.autoCreateVersionTable", "false");
    }

    public static String getConfiguredClassName(Class type, String ... implementationDiscriminatorValues) {
        String propKey = type.getName() + ".implClassName";
        if (implementationDiscriminatorValues != null) {
            String implementationSpecificPropKey = propKey;
            for (String implementationDiscriminatorValue : implementationDiscriminatorValues) {
                implementationSpecificPropKey = implementationSpecificPropKey + '.' + implementationDiscriminatorValue;
            }
            if (ConfigurationHelper.hasProperty(implementationSpecificPropKey)) {
                return ConfigurationHelper.getString(implementationSpecificPropKey);
            }
        }
        if (ConfigurationHelper.hasProperty(propKey)) {
            return ConfigurationHelper.getString(propKey);
        }
        throw new JTesterException("Missing configuration for " + propKey);
    }
}

