/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import ognl.DefaultMemberAccess;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.jtester.bytecode.reflector.helper.FieldHelper;
import org.jtester.exception.JTesterException;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionModuleHelper {
    public static Object injectInto(Object objectToInject, Object target, String property) {
        if (target == null) {
            throw new JTesterException("Target for injection should not be null");
        }
        try {
            OgnlContext ognlContext = new OgnlContext();
            ognlContext.setMemberAccess((MemberAccess)new DefaultMemberAccess(true));
            Object ognlExpression = Ognl.parseExpression((String)property);
            Object oldValue = null;
            try {
                Ognl.getValue((Object)ognlExpression, (Map)ognlContext, (Object)target);
            }
            catch (Throwable e) {
                JTesterLogger.warn("Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", e);
            }
            Ognl.setValue((Object)ognlExpression, (Map)ognlContext, (Object)target, (Object)objectToInject);
            return oldValue;
        }
        catch (OgnlException e) {
            throw new JTesterException("Failed to set value using OGNL expression " + property, e);
        }
    }

    public static Object injectIntoByType(Object objectToInject, Type objectToInjectType, Object target) {
        if (target == null) {
            throw new JTesterException("Target for injection should not be null");
        }
        return InjectionModuleHelper.injectIntoFieldByType(objectToInject, objectToInjectType, target, target.getClass());
    }

    public static void injectIntoAnnotated(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        InjectionModuleHelper.injectIntoAnnotatedFields(objectToInject, target, annotation);
        InjectionModuleHelper.injectIntoAnnotatedMethods(objectToInject, target, annotation);
    }

    public static void injectIntoAnnotatedMethods(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        Set<Method> annotatedMethods = AnnotationUtils.getMethodsAnnotatedWith(target.getClass(), annotation);
        for (Method annotatedMethod : annotatedMethods) {
            try {
                annotatedMethod.invoke(target, objectToInject);
            }
            catch (IllegalArgumentException e) {
                throw new JTesterException("Method " + annotatedMethod.getName() + " annotated with " + annotation.getName() + " must have exactly one argument with a type equal to or a superclass / implemented interface of " + objectToInject.getClass().getSimpleName());
            }
            catch (IllegalAccessException e) {
                throw new JTesterException("Unable to inject value into following method annotated with " + annotation.getName() + ": " + annotatedMethod.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new JTesterException("Unable to inject value into following method annotated with " + annotation.getName() + ": " + annotatedMethod.getName(), e);
            }
        }
    }

    public static void injectIntoAnnotatedFields(Object objectToInject, Object target, Class<? extends Annotation> annotation) {
        Set<Field> annotatedFields = AnnotationUtils.getFieldsAnnotatedWith(target.getClass(), annotation);
        for (Field annotatedField : annotatedFields) {
            FieldHelper.setFieldValue(target, annotatedField, objectToInject);
        }
    }

    private static Object injectIntoFieldByType(Object objectToInject, Type objectToInjectType, Object target, Class targetClass) {
        Field fieldToInjectTo = null;
        Set<Field> fieldsWithExactType = FieldHelper.getFieldsOfType(targetClass, objectToInjectType);
        if (fieldsWithExactType.size() > 1) {
            StringBuilder message = new StringBuilder("More than one field with type " + objectToInjectType + " found in " + targetClass.getSimpleName() + ".");
            if (objectToInjectType instanceof Class) {
                message.append(" If the target is a generic type, this can be caused by type erasure.");
            }
            message.append(" Specify the target field explicitly instead of injecting into by type.");
            throw new JTesterException(message.toString());
        }
        if (fieldsWithExactType.size() == 1) {
            fieldToInjectTo = fieldsWithExactType.iterator().next();
        } else {
            Set<Field> fieldsOfType = FieldHelper.getFieldsAssignableFrom(targetClass, objectToInjectType);
            if (fieldsOfType.size() == 0) {
                throw new JTesterException("No field with (super)type " + objectToInjectType + " found in " + targetClass.getSimpleName());
            }
            for (Field field : fieldsOfType) {
                boolean moreSpecific = true;
                for (Field compareToField : fieldsOfType) {
                    if (field == compareToField || !field.getClass().isAssignableFrom(compareToField.getClass())) continue;
                    moreSpecific = false;
                    break;
                }
                if (!moreSpecific) continue;
                fieldToInjectTo = field;
                break;
            }
            if (fieldToInjectTo == null) {
                throw new JTesterException("Multiple candidate target fields found in " + targetClass.getSimpleName() + ", with none of them more specific than all others.");
            }
        }
        Object oldValue = null;
        try {
            oldValue = FieldHelper.getFieldValue(target, fieldToInjectTo);
        }
        catch (Throwable e) {
            JTesterLogger.warn("Unable to retrieve current value of field to inject into. Will not be able to restore value after injection.", e);
        }
        FieldHelper.setFieldValue(target, fieldToInjectTo, objectToInject);
        return oldValue;
    }
}

