/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import ext.jtester.org.apache.commons.lang.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.ConfigurationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleHelper {
    public static final String DEFAULT_ENUM_VALUE_NAME = "DEFAULT";

    public static Map<Class<? extends Annotation>, Map<String, String>> getAnnotationPropertyDefaults(Class<? extends Module> moduleClass, Class<? extends Annotation> ... annotationClasses) {
        HashMap<Class<? extends Annotation>, Map<String, String>> result = new HashMap<Class<? extends Annotation>, Map<String, String>>();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            Method[] methods;
            for (Method method : methods = annotationClass.getDeclaredMethods()) {
                String defaultValue = ModuleHelper.getAnnotationPropertyDefault(moduleClass, annotationClass, method.getName());
                HashMap<String, String> defaultValueMap = (HashMap<String, String>)result.get(annotationClass);
                if (defaultValueMap == null) {
                    defaultValueMap = new HashMap<String, String>();
                    result.put(annotationClass, defaultValueMap);
                }
                defaultValueMap.put(method.getName(), defaultValue);
            }
        }
        return result;
    }

    private static String getAnnotationPropertyDefault(Class<? extends Module> moduleClass, Class<? extends Annotation> annotationClass, String name) {
        String propertyName = ClassUtils.getShortClassName(moduleClass) + "." + ClassUtils.getShortClassName(annotationClass) + "." + name + ".default";
        if (!ConfigurationHelper.hasProperty(propertyName)) {
            return null;
        }
        return ConfigurationHelper.getString(propertyName);
    }

    public static <T extends Enum<?>> T getEnumValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, T enumValue, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues) {
        return ModuleHelper.getEnumValueReplaceDefault(annotation, annotationPropertyName, enumValue, allDefaultValues, DEFAULT_ENUM_VALUE_NAME);
    }

    private static <T extends Enum<?>> T getEnumValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, T enumValue, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, String defaultValueName) {
        String valueAsString = ModuleHelper.getValueAsStringReplaceDefault(annotation, annotationPropertyName, enumValue.name(), allDefaultValues, defaultValueName);
        return (T)ClazzHelper.getEnumValue(enumValue.getClass(), valueAsString);
    }

    public static Class getClassValueReplaceDefault(Class<? extends Annotation> annotation, String annotationPropertyName, Class value, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, Class defaultValueClass) {
        String valueAsString = ModuleHelper.getValueAsStringReplaceDefault(annotation, annotationPropertyName, value.getName(), allDefaultValues, defaultValueClass.getName());
        return ClazzHelper.getClazz(valueAsString);
    }

    private static String getValueAsStringReplaceDefault(Class<? extends Annotation> annotation, String annotationProperty, String valueAsString, Map<Class<? extends Annotation>, Map<String, String>> allDefaultValues, String defaultValueName) {
        String defaultValueAsString;
        if (!defaultValueName.equalsIgnoreCase(valueAsString)) {
            return valueAsString;
        }
        Map<String, String> defaultValues = allDefaultValues.get(annotation);
        if (defaultValues != null && (defaultValueAsString = defaultValues.get(annotationProperty)) != null) {
            return defaultValueAsString;
        }
        throw new JTesterException("Could not replace default value. No default value found for annotation: " + annotation + ", property " + annotationProperty + ", defaultValues: " + allDefaultValues);
    }
}

