/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.TestListener;
import org.jtester.module.core.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesManager {
    private static ModulesManager modulesManager = null;
    private List<Module> modules = null;
    private List<TestListener> testListeners = null;
    private List<TestListener> testListeners_Reverse = null;
    private Map<Module, TestListener> testListenersMap = null;

    public static final void initManager(List<Module> modules) {
        modulesManager = new ModulesManager(modules);
    }

    private ModulesManager(List<Module> modules) {
        this.modules = modules;
        this.testListeners = new ArrayList<TestListener>();
        this.testListeners_Reverse = new ArrayList<TestListener>();
        this.testListenersMap = new HashMap<Module, TestListener>();
        for (Module module : modules) {
            TestListener listener = module.getTestListener();
            this.testListeners.add(listener);
            this.testListeners_Reverse.add(listener);
            this.testListenersMap.put(module, listener);
        }
        Collections.reverse(this.testListeners_Reverse);
    }

    public static ModulesManager instance() {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        return modulesManager;
    }

    public static List<Module> getModules() {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        return ModulesManager.modulesManager.modules;
    }

    public static TestListener getTestListener(Module module) {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        return ModulesManager.modulesManager.testListenersMap.get(module);
    }

    public static List<TestListener> getTestListeners() {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        return ModulesManager.modulesManager.testListeners;
    }

    public static List<TestListener> getTestListeners_Reverse() {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        return ModulesManager.modulesManager.testListeners_Reverse;
    }

    public static <T extends Module> T getModuleInstance(Class<T> type) {
        List<T> modulesOfType = ModulesManager.getModulesOfType(type);
        if (modulesOfType.size() > 1) {
            throw new JTesterException("More than one module found of type " + type.getName());
        }
        if (modulesOfType.size() < 1) {
            throw new JTesterException("No module found of type " + type.getName());
        }
        return (T)((Module)modulesOfType.get(0));
    }

    private static <T> List<T> getModulesOfType(Class<T> type) {
        if (modulesManager == null) {
            throw new RuntimeException("there are some error before jTester loading, modules haven't been loaded.");
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : ModulesManager.modulesManager.modules) {
            if (!type.isAssignableFrom(module.getClass())) continue;
            result.add(module);
        }
        return result;
    }

    public boolean isModuleEnabled(String fullyQualifiedClassName) {
        Class moduleClass;
        try {
            moduleClass = ClazzHelper.getClazz(fullyQualifiedClassName);
        }
        catch (Throwable e) {
            return false;
        }
        return ModulesManager.isModuleEnabled(moduleClass);
    }

    public static boolean isModuleEnabled(Class<? extends Module> moduleClass) {
        List<? extends Module> modulesOfType = ModulesManager.getModulesOfType(moduleClass);
        if (modulesOfType.size() > 1) {
            throw new JTesterException("More than one module found of type " + moduleClass.getName());
        }
        return modulesOfType.size() == 1;
    }
}

