/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import java.util.Arrays;
import org.jtester.annotations.SpringApplicationContext;
import org.jtester.core.TestedObject;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.SpringModule;
import org.jtester.module.core.helper.ModulesManager;
import org.jtester.module.spring.ApplicationContextFactory;
import org.jtester.module.spring.JTesterBeanFactory;
import org.jtester.module.spring.JTesterSpringContext;
import org.jtester.module.tracer.spring.SpringBeanTracer;
import org.jtester.module.tracer.spring.TracerMethodRegexPointcut;
import org.jtester.utility.AnnotationUtils;
import org.jtester.utility.JTesterLogger;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;

public class SpringModuleHelper {
    public static Object getBeanByName(String beanname) {
        JTesterBeanFactory factory = TestedObject.getSpringBeanFactory();
        if (factory == null) {
            throw new RuntimeException("can't find SpringApplicationContext for tested class:" + TestedObject.currTestedClazzName());
        }
        Object bean = factory.getBean(beanname);
        return bean;
    }

    public static void invalidateApplicationContext() {
        boolean springModuleEnabled = ModulesManager.isModuleEnabled(SpringModule.class);
        if (springModuleEnabled) {
            SpringModule module = ModulesManager.getModuleInstance(SpringModule.class);
            module.invalidateApplicationContext();
        }
    }

    public static JTesterBeanFactory initSpringContext(Class testClazz, ApplicationContextFactory contextFactory) {
        JTesterBeanFactory beanFactory = TestedObject.getSpringBeanFactory();
        if (beanFactory != null) {
            return beanFactory;
        }
        SpringApplicationContext annotation = AnnotationUtils.getClassLevelAnnotation(SpringApplicationContext.class, testClazz);
        if (annotation == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        String[] locations = annotation.value();
        boolean ignoreNoSuchBean = annotation.ignoreNoSuchBean();
        JTesterSpringContext context = contextFactory.createApplicationContext(Arrays.asList(locations), ignoreNoSuchBean);
        context.refresh();
        long duration = System.currentTimeMillis() - startTime;
        JTesterLogger.warn(String.format("take %d ms to init spring context for test obejct[%s]", duration, testClazz.getName()));
        beanFactory = context.getJTesterBeanFactory();
        TestedObject.setSpringContext(beanFactory);
        return beanFactory;
    }

    public static void closeSpringContext(Object beanFactory) {
        if (beanFactory == null) {
            return;
        }
        if (!(beanFactory instanceof JTesterBeanFactory)) {
            String error = String.format("there must be something error, the type[%s] object isn't a spring context.", beanFactory.getClass().getName());
            throw new RuntimeException(error);
        }
        ((JTesterBeanFactory)((Object)beanFactory)).destroySingletons();
        JTesterLogger.warn("close spring context for class:" + TestedObject.currTestedClazzName());
    }

    public static void addTracerBeanDefinition(BeanDefinitionRegistry beanFactory) {
        GenericBeanDefinition pointcut = new GenericBeanDefinition();
        pointcut.setBeanClassName(TracerMethodRegexPointcut.class.getName());
        pointcut.setScope("singleton");
        pointcut.setAutowireCandidate(false);
        pointcut.setAutowireMode(0);
        beanFactory.registerBeanDefinition("jtester-internal-methodname-pointcut", (BeanDefinition)pointcut);
        GenericBeanDefinition advice = new GenericBeanDefinition();
        advice.setBeanClassName(SpringBeanTracer.class.getName());
        advice.setScope("singleton");
        advice.setAutowireCandidate(false);
        advice.setAutowireMode(0);
        beanFactory.registerBeanDefinition("jtester-internal-springbeantracer", (BeanDefinition)advice);
        GenericBeanDefinition advisor = new GenericBeanDefinition();
        advisor.setBeanClassName(DefaultPointcutAdvisor.class.getName());
        advisor.setScope("singleton");
        advisor.setAutowireCandidate(false);
        advisor.setAutowireMode(0);
        advisor.getPropertyValues().addPropertyValue("pointcut", (Object)new RuntimeBeanReference("jtester-internal-methodname-pointcut"));
        advisor.getPropertyValues().addPropertyValue("advice", (Object)new RuntimeBeanReference("jtester-internal-springbeantracer"));
        beanFactory.registerBeanDefinition("jtester-internal-beantracer-advisor", (BeanDefinition)advisor);
    }

    public static Object getAdvisedObject(Object target) {
        if (target instanceof Advised) {
            try {
                return ((Advised)target).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new JTesterException(e);
            }
        }
        return target;
    }
}

