/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.helper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public class TracerModuleHelper {
    public static final String TRACE_JDBC_KEY = "tracer.database";
    public static final String TRACE_SPRING_KEY = "tracer.springbean";

    public static boolean traceJDBC() {
        boolean traceJDBC = ConfigurationHelper.getBoolean(TRACE_JDBC_KEY);
        return traceJDBC;
    }

    public static boolean traceSpringBean() {
        boolean traceBean = ConfigurationHelper.getBoolean(TRACE_SPRING_KEY);
        return traceBean;
    }

    public static File getAboutMethodFile(Object testObject, Method testMethod, String surfix) {
        String basedir = System.getProperty("user.dir") + "/target/tracer/";
        String clazzName = testObject.getClass().getName();
        String methodName = testMethod.getName();
        String path = basedir + clazzName.replace('.', '/');
        File htmlFile = new File(path + "#" + methodName + surfix);
        ResourceHelper.mkFileParentDir(htmlFile);
        return htmlFile;
    }

    public static void writeTracerInfo(File htmlFile, String jpgFile, String beanTracerInfo, String jdbcTracerInfo) {
        try {
            FileWriter writer = new FileWriter(htmlFile);
            writer.append("<html><head>");
            writer.append(String.format("<META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=%s'>", ResourceHelper.defaultFileEncoding()));
            writer.append("<style>");
            InputStream is = ResourceHelper.getResourceAsStream("org/jtester/testng/UserTestReporter.css");
            if (is != null) {
                String style = ResourceHelper.readFromStream(is);
                writer.append(style);
            }
            writer.append("</style></head>");
            if (jpgFile != null) {
                writer.append(String.format("<img src='%s'/><br/>", URLEncoder.encode(jpgFile, "utf-8")));
            }
            if (!StringHelper.isBlankOrNull(beanTracerInfo)) {
                writer.write(beanTracerInfo);
            }
            writer.write("<br/>");
            if (!StringHelper.isBlankOrNull(jdbcTracerInfo)) {
                writer.write(jdbcTracerInfo);
            }
            writer.append("</html>");
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

