/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.loader;

import ext.jtester.org.apache.commons.lang.text.StrSubstitutor;
import java.util.Map;
import java.util.Properties;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.utils.PropertiesReader;
import org.jtester.utility.JTesterLogger;

public class ConfigurationLoader {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "jtester-default.properties";
    public static final String PROPKEY_CUSTOM_CONFIGURATION = "jtester.configuration.customFileName";
    public static final String PROPKEY_LOCAL_CONFIGURATION = "jtester.configuration.localFileName";
    private PropertiesReader propertiesReader = new PropertiesReader();
    private static Properties properties = null;

    public static synchronized Properties loading() {
        if (properties == null) {
            ConfigurationLoader loader = new ConfigurationLoader();
            properties = new Properties();
            loader.loadDefaultConfiguration(properties);
            loader.loadCustomConfiguration(properties);
            loader.loadLocalConfiguration(properties);
            loader.loadSystemProperties(properties);
            loader.expandPropertyValues(properties);
        }
        return properties;
    }

    private ConfigurationLoader() {
    }

    private void loadDefaultConfiguration(Properties properties) {
        Properties defaultProperties = this.propertiesReader.loadPropertiesFileFromClasspath(DEFAULT_PROPERTIES_FILE_NAME);
        if (defaultProperties == null) {
            throw new JTesterException("Configuration file: jtester-default.properties not found in classpath.");
        }
        properties.putAll((Map<?, ?>)defaultProperties);
    }

    private void loadCustomConfiguration(Properties properties) {
        String customConfigurationFileName = this.getConfigurationFileName(PROPKEY_CUSTOM_CONFIGURATION, properties);
        Properties customProperties = this.propertiesReader.loadPropertiesFileFromClasspath(customConfigurationFileName);
        if (customProperties == null) {
            JTesterLogger.warn("No custom configuration file " + customConfigurationFileName + " found.");
        } else {
            properties.putAll((Map<?, ?>)customProperties);
        }
    }

    private void loadLocalConfiguration(Properties properties) {
        String localConfigurationFileName = this.getConfigurationFileName(PROPKEY_LOCAL_CONFIGURATION, properties);
        Properties localProperties = this.propertiesReader.loadPropertiesFileFromClasspath(localConfigurationFileName);
        if (localProperties == null) {
            localProperties = this.propertiesReader.loadPropertiesFileFromUserHome(localConfigurationFileName);
        }
        if (localProperties == null) {
            JTesterLogger.info("No local configuration file " + localConfigurationFileName + " found.");
        } else {
            properties.putAll((Map<?, ?>)localProperties);
        }
    }

    private void loadSystemProperties(Properties properties) {
        properties.putAll((Map<?, ?>)System.getProperties());
    }

    private void expandPropertyValues(Properties properties) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            try {
                String expandedValue = StrSubstitutor.replace(value, properties);
                properties.put(key, expandedValue);
            }
            catch (Throwable e) {
                throw new JTesterException("Unable to load unitils configuration. Could not expand property value for key: " + key + ", value " + value, e);
            }
        }
    }

    private String getConfigurationFileName(String propertyName, Properties properties) {
        String configurationFileName = System.getProperty(propertyName);
        if (configurationFileName != null) {
            return configurationFileName;
        }
        return ConfigurationHelper.getString(properties, propertyName);
    }
}

