/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.core.loader;

import java.util.ArrayList;
import java.util.List;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.exception.JTesterException;
import org.jtester.module.core.Module;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.core.helper.ModulesManager;
import org.jtester.utility.JTesterLogger;
import org.jtester.utility.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesLoader {
    public static final String PROPKEY_MODULE_PREFIX = "jtester.module.";
    public static final String PROPKEY_MODULE_SUFFIX_ENABLED = ".enabled";
    public static final String PROPKEY_MODULE_ENABLED_CLASS = ".enabled.class";
    public static final String PROPKEY_MODULE_SUFFIX_CLASS_NAME = ".className";

    public static List<Module> loading() {
        List<String> moduleNames = ConfigurationHelper.getStringList("jtester.modules");
        moduleNames = ModulesLoader.filterModules(moduleNames);
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleName : moduleNames) {
            String className = ConfigurationHelper.getString(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_CLASS_NAME);
            try {
                Object module = ClazzHelper.createInstanceOfType(className);
                if (!(module instanceof Module)) {
                    throw new JTesterException("Unable to load core. Module class is not of type JTesterModule: " + className);
                }
                ((Module)module).init();
                modules.add((Module)module);
            }
            catch (Throwable t) {
                throw new JTesterException("An exception occured during the loading of core module " + moduleName + " with module class name " + className, t);
            }
        }
        ModulesManager.initManager(modules);
        return modules;
    }

    private static List<String> filterModules(List<String> modules) {
        ArrayList<String> enabledModules = new ArrayList<String>();
        String dbType = ConfigurationHelper.databaseType();
        for (String module : modules) {
            boolean isEnabled;
            if (StringHelper.isBlankOrNull(dbType) && (module.equalsIgnoreCase("database") || module.equalsIgnoreCase("dbfit")) || !(isEnabled = ConfigurationHelper.getBoolean(PROPKEY_MODULE_PREFIX + module + PROPKEY_MODULE_SUFFIX_ENABLED, true))) continue;
            String moduleEnabledClazz = ConfigurationHelper.getString(PROPKEY_MODULE_PREFIX + module + PROPKEY_MODULE_ENABLED_CLASS);
            if (StringHelper.isBlankOrNull(moduleEnabledClazz)) {
                enabledModules.add(module);
                continue;
            }
            boolean clazzAvailable = ClazzHelper.isClassAvailable(moduleEnabledClazz);
            if (clazzAvailable) {
                enabledModules.add(module);
                continue;
            }
            JTesterLogger.warn(String.format("can't find class %s in classpath, so disabled module[%s]", clazzAvailable, module));
        }
        return enabledModules;
    }
}

