/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.tracer.jdbc.ConnectionProxy;
import org.jtester.utility.JTesterLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTesterDataSource
implements DataSource {
    private DataSource dataSource;
    private final DataSourceType type;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String schemaNames;
    private static boolean proxy = ConfigurationHelper.getBoolean("database.prxoy.enabled");
    Connection conn;
    private static final Set<String> registered = new HashSet<String>();

    public JTesterDataSource(DataSourceType type, String driver, String url, String schemaNames, String user, String pass) {
        this.type = type;
        this.driver = driver;
        this.url = url;
        this.schemaNames = schemaNames;
        this.username = user;
        this.password = pass;
        this.dataSource = this.createDataSource();
    }

    private DataSource createDataSource() {
        this.checkDoesTestDB();
        this.registerDriver();
        BasicDataSource dataSource = new BasicDataSource();
        JTesterLogger.info("Creating data source. Driver: " + this.driver + ", url: " + this.url + ", user: " + this.username + ", password: <not shown>");
        dataSource.setDriverClassName(this.driver);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        return dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        if (proxy) {
            return ConnectionProxy.getConnectionProxy(conn);
        }
        return conn;
    }

    @Override
    public Connection getConnection(String arg0, String arg1) throws SQLException {
        Connection conn = this.dataSource.getConnection(arg0, arg1);
        if (proxy) {
            return ConnectionProxy.getConnectionProxy(conn);
        }
        return conn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter arg0) throws SQLException {
        this.dataSource.setLogWriter(arg0);
    }

    @Override
    public void setLoginTimeout(int arg0) throws SQLException {
        this.dataSource.setLoginTimeout(arg0);
    }

    private void checkDoesTestDB() {
        String[] schemas;
        if (!ConfigurationHelper.doesOnlyTestDatabase()) {
            return;
        }
        if (this.type.isMemoryDB()) {
            return;
        }
        if (this.url.contains("127.0.0.1") || this.url.toUpperCase().contains("LOCALHOST")) {
            return;
        }
        for (String schema : schemas = this.schemaNames.split(";")) {
            String temp;
            if (schema.trim().equals("") || (temp = schema.toUpperCase()).endsWith("TEST") || temp.startsWith("TEST")) continue;
            throw new RuntimeException("only local db or test db will be allowed to connect,url:" + this.url + ", schemas:" + this.schemaNames);
        }
    }

    public String toString() {
        return "JTesterDataSource [type=" + (Object)((Object)this.type) + ", driver=" + this.driver + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", schemaNames=" + this.schemaNames + "]";
    }

    private void registerDriver() {
        try {
            if (registered.contains(this.driver)) {
                return;
            }
            DriverManager.registerDriver((Driver)Class.forName(this.driver).newInstance());
            registered.add(this.driver);
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot register SQL driver " + this.driver);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("unimplement");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("unimplement");
    }
}

