/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.dbop;

import java.util.ArrayList;
import java.util.List;
import org.jtester.core.IJTester;
import org.jtester.json.JSON;
import org.jtester.module.database.datagenerator.AbastractDataGenerator;
import org.jtester.module.database.dbop.InsertOp;
import org.jtester.utility.ArrayHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSet {
    private List<IJTester.DataMap> datas = new ArrayList<IJTester.DataMap>();

    public void data(int count, IJTester.DataMap datas) {
        List<IJTester.DataMap> list = AbstractDataSet.parseMapList(count, datas);
        this.datas.addAll(list);
    }

    public void data(IJTester.DataMap data) {
        this.datas.add(data);
    }

    public void data(String json) {
        IJTester.DataMap data = (IJTester.DataMap)JSON.toObject(json, IJTester.DataMap.class);
        this.datas.add(data);
    }

    public void insert(String table) {
        for (IJTester.DataMap map : this.datas) {
            InsertOp.insert(table, map);
        }
    }

    public static List<IJTester.DataMap> parseMapList(int count, IJTester.DataMap datas) {
        ArrayList<IJTester.DataMap> list = new ArrayList<IJTester.DataMap>();
        for (int index = 0; index < count; ++index) {
            IJTester.DataMap data = new IJTester.DataMap();
            for (String key : datas.keySet()) {
                Object dataGenerator = datas.get(key);
                Object value = AbstractDataSet.getObjectFromDataGenerator(data, dataGenerator, index);
                data.put(key, value);
            }
            list.add(data);
        }
        return list;
    }

    private static Object getObjectFromDataGenerator(IJTester.DataMap dataMap, Object dataGenerator, int index) {
        if (ArrayHelper.isCollOrArray(dataGenerator)) {
            Object[] oa = ArrayHelper.toArray(dataGenerator);
            int count = oa.length;
            Object value = index < count ? oa[index] : oa[count - 1];
            return value;
        }
        if (dataGenerator instanceof AbastractDataGenerator) {
            AbastractDataGenerator generator = (AbastractDataGenerator)dataGenerator;
            generator.setDataMap(dataMap);
            return generator.generate(index);
        }
        return dataGenerator;
    }

    public static final class EmptyDataSet
    extends AbstractDataSet {
    }
}

