/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.dbop;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.hamcrest.iassert.object.impl.CollectionAssert;
import org.jtester.hamcrest.iassert.object.impl.MapAssert;
import org.jtester.hamcrest.iassert.object.impl.ObjectAssert;
import org.jtester.hamcrest.iassert.object.intf.ICollectionAssert;
import org.jtester.hamcrest.iassert.object.intf.IMapAssert;
import org.jtester.hamcrest.iassert.object.intf.IObjectAssert;
import org.jtester.module.database.dbop.IDBOperator;
import org.jtester.module.database.dbop.ITableOp;
import org.jtester.module.database.dbop.SqlSet;
import org.jtester.module.database.dbop.TableOp;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.util.SqlRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBOperator
implements IDBOperator {
    public static ThreadLocal<Boolean> IN_DB_OPERATOR = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator useDB(String dataSource) {
        IN_DB_OPERATOR.set(true);
        try {
            DBEnvironment environment = DBEnvironmentFactory.getDBEnvironment(dataSource);
            DBEnvironmentFactory.changeDBEnvironment(environment);
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator useDefaultDB() {
        IN_DB_OPERATOR.set(true);
        try {
            DBEnvironment environment = DBEnvironmentFactory.getDBEnvironment();
            DBEnvironmentFactory.changeDBEnvironment(environment);
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator cleanTable(String table, String ... more) {
        IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.execute("delete from " + table);
            for (String item : more) {
                SqlRunner.execute("delete from " + item);
            }
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator execute(String sql) {
        IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.execute(sql);
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator execute(File file) {
        IN_DB_OPERATOR.set(true);
        try {
            try {
                SqlRunner.executeFromStream(new FileInputStream(file));
            }
            catch (Exception e) {
                throw ExceptionWrapper.wrapWithRuntimeException(e);
            }
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator commit() {
        IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.commit();
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator rollback() {
        IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.rollback();
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMapAssert queryAsMap(String query) {
        IN_DB_OPERATOR.set(true);
        try {
            Map<String, Object> map = SqlRunner.queryMap(query);
            MapAssert mapAssert = new MapAssert(map);
            return mapAssert;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectAssert queryAsPoJo(String query, Class objClazz) {
        IN_DB_OPERATOR.set(true);
        try {
            Object o = SqlRunner.query(query, objClazz);
            ObjectAssert objectAssert = new ObjectAssert(o);
            return objectAssert;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert query(String sql) {
        IN_DB_OPERATOR.set(true);
        try {
            List list = SqlRunner.queryMapList(sql);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert queryList(String query, Class pojo) {
        IN_DB_OPERATOR.set(true);
        try {
            List list = SqlRunner.queryList(query, pojo);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITableOp table(String table) {
        IN_DB_OPERATOR.set(true);
        try {
            TableOp tableOperator;
            TableOp tableOp = tableOperator = new TableOp(table);
            return tableOp;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDBOperator execute(SqlSet sqlSet) {
        IN_DB_OPERATOR.set(true);
        try {
            if (sqlSet == null) {
                throw new RuntimeException("the insert sqlSet can't be null.");
            }
            sqlSet.execute();
            DBOperator dBOperator = this;
            return dBOperator;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> returnList(String table) {
        IN_DB_OPERATOR.set(true);
        try {
            List<Map<String, Object>> list;
            String query = "select * from " + table;
            List<Map<String, Object>> list2 = list = SqlRunner.queryMapList(query);
            return list2;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> returnList(String table, Class pojoClazz) {
        IN_DB_OPERATOR.set(true);
        try {
            List<Object> list;
            String query = "select * from " + table;
            List<Object> list2 = list = SqlRunner.queryList(query, pojoClazz);
            return list2;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> returnQuery(String query) {
        IN_DB_OPERATOR.set(true);
        try {
            List<Map<String, Object>> list;
            List<Map<String, Object>> list2 = list = SqlRunner.queryMapList(query);
            return list2;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> returnQuery(String query, Class pojoClazz) {
        IN_DB_OPERATOR.set(true);
        try {
            List<Object> list;
            List<Object> list2 = list = SqlRunner.queryList(query, pojoClazz);
            return list2;
        }
        finally {
            IN_DB_OPERATOR.set(false);
        }
    }

    static {
        IN_DB_OPERATOR.set(false);
    }
}

