/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.dbop;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.jtester.core.IJTester;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.DBEnvironmentFactory;
import org.jtester.module.database.environment.TableMeta;
import org.jtester.module.database.util.DBHelper;

public class InsertOp {
    private String table;
    private IJTester.DataMap data;
    private DBEnvironment dbEnvironment;
    private TableMeta tableMeta;
    private String quato;

    private InsertOp(String table, IJTester.DataMap data) {
        this.table = table;
        this.data = data;
        this.dbEnvironment = DBEnvironmentFactory.getCurrentDBEnvironment();
        this.tableMeta = this.dbEnvironment.getTableMetaData(table);
        this.quato = this.dbEnvironment.getFieldQuato();
    }

    void insert() throws Exception {
        Connection connection = this.dbEnvironment.connectIfNeeded();
        this.tableMeta.fillData(this.data, this.dbEnvironment);
        String sql = this.getInsertCommandText();
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.clearParameters();
        int index = 1;
        for (String key : this.data.keySet()) {
            try {
                Object value = this.getValueByColumn(key);
                if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    statement.setBinaryStream(index, is, is.available());
                } else {
                    statement.setObject(index, value);
                }
                ++index;
            }
            catch (Throwable e) {
                throw new RuntimeException("set column[" + key + "] value error:" + e.getMessage(), e);
            }
        }
        try {
            statement.execute();
        }
        catch (Exception e) {
            RuntimeException e1 = ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            StringBuffer msg = new StringBuffer();
            msg.append("statement:" + sql);
            msg.append("\ninsert data error, data=\n");
            msg.append(this.data.toString());
            throw new RuntimeException(msg.toString(), e1);
        }
        finally {
            DBHelper.closeStatement(statement);
        }
    }

    private Object getValueByColumn(String column) {
        Object value = this.data.get(column);
        if (!(value instanceof String)) {
            return value;
        }
        String javaType = this.tableMeta.getColumnType(column);
        value = String.class.getName().equals(javaType) ? this.tableMeta.truncateString(column, (String)value) : this.dbEnvironment.toObjectValue((String)value, javaType);
        return value;
    }

    private String getInsertCommandText() {
        StringBuilder text = new StringBuilder();
        StringBuilder values = new StringBuilder();
        text.append("insert into ").append(this.table).append("(");
        boolean isFirst = true;
        for (String key : this.data.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                text.append(",");
                values.append(",");
            }
            text.append(this.quato).append(key).append(this.quato);
            values.append("?");
        }
        text.append(") values(").append((CharSequence)values).append(")");
        return text.toString();
    }

    public static void insert(String table, IJTester.DataMap data) {
        try {
            InsertOp op = new InsertOp(table, data);
            op.insert();
        }
        catch (Exception e) {
            throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
        }
    }
}

