/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.dbop;

import java.util.List;
import org.jtester.core.IJTester;
import org.jtester.hamcrest.iassert.object.impl.CollectionAssert;
import org.jtester.hamcrest.iassert.object.impl.LongAssert;
import org.jtester.hamcrest.iassert.object.impl.ObjectAssert;
import org.jtester.hamcrest.iassert.object.intf.ICollectionAssert;
import org.jtester.hamcrest.iassert.object.intf.INumberAssert;
import org.jtester.hamcrest.iassert.object.intf.IObjectAssert;
import org.jtester.json.JSON;
import org.jtester.module.database.dbop.AbstractDataSet;
import org.jtester.module.database.dbop.DBOperator;
import org.jtester.module.database.dbop.ITableOp;
import org.jtester.module.database.dbop.InsertOp;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.SqlRunner;
import org.jtester.utility.StringHelper;

public class TableOp
implements ITableOp {
    private static final long serialVersionUID = -5859213164627788602L;
    private String table;

    public TableOp(String table) {
        this.table = table;
        if (StringHelper.isBlankOrNull(this.table)) {
            throw new RuntimeException("the table name can't be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableOp clean() {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String sql = "delete from " + this.table;
            SqlRunner.execute(sql);
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.commit();
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            SqlRunner.rollback();
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableOp insert(IJTester.DataMap data, IJTester.DataMap ... more) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            InsertOp.insert(this.table, data);
            for (IJTester.DataMap map : more) {
                InsertOp.insert(this.table, map);
            }
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableOp insert(String json, String ... more) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            IJTester.DataMap map = (IJTester.DataMap)JSON.toObject(json, IJTester.DataMap.class);
            InsertOp.insert(this.table, map);
            for (String item : more) {
                map = (IJTester.DataMap)JSON.toObject(item, IJTester.DataMap.class);
                InsertOp.insert(this.table, map);
            }
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableOp insert(int count, IJTester.DataMap datas) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            AbstractDataSet.EmptyDataSet ds = new AbstractDataSet.EmptyDataSet();
            ds.data(count, datas);
            ds.insert(this.table);
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITableOp insert(AbstractDataSet dataset) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            if (dataset == null) {
                throw new RuntimeException("the insert dataset can't be null.");
            }
            dataset.insert(this.table);
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollectionAssert query() {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String query = "select * from " + this.table;
            List list = SqlRunner.queryMapList(query);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollectionAssert queryList(Class pojo) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String query = "select * from " + this.table;
            List list = SqlRunner.queryList(query, pojo);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INumberAssert count() {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String query = "select count(*) from " + this.table;
            Number number = (Number)SqlRunner.query(query, Object.class);
            LongAssert longAssert = new LongAssert(number.longValue());
            return longAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectAssert queryAs(Class pojo) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String query = "select * from " + this.table;
            Object o = SqlRunner.query(query, pojo);
            ObjectAssert objectAssert = new ObjectAssert(o);
            return objectAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollectionAssert queryWhere(String where) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            String query = "select * from " + this.table + " where " + where;
            List list = SqlRunner.queryMapList(query);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICollectionAssert queryWhere(IJTester.DataMap dataMap) {
        DBOperator.IN_DB_OPERATOR.set(true);
        try {
            StringBuilder query = new StringBuilder("select * from ");
            query.append(this.table).append(" ");
            String where = DBHelper.getWhereCondiction(dataMap);
            query.append(where);
            List list = SqlRunner.queryMapList(query.toString(), dataMap);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            DBOperator.IN_DB_OPERATOR.set(false);
        }
    }
}

