/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment;

import fit.TypeAdapter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jtester.bytecode.reflector.helper.ClazzHelper;
import org.jtester.core.TestedObject;
import org.jtester.core.context.DbFitContext;
import org.jtester.exception.ExceptionWrapper;
import org.jtester.fit.util.SymbolUtil;
import org.jtester.module.database.JTesterDataSource;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.TableMeta;
import org.jtester.module.database.environment.typesmap.AbstractTypeMap;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.BigDecimalParseDelegate;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.module.dbfit.db.model.SqlDateParseDelegate;
import org.jtester.module.dbfit.db.model.SqlTimestampParseDelegate;
import org.jtester.utility.JTesterLogger;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public abstract class AbstractDBEnvironment
implements DBEnvironment {
    protected Connection connection;
    protected final String dataSourceName;
    protected final String dataSourceFrom;
    protected DataSourceType dataSourceType;
    private JTesterDataSource jtesterDataSource;
    private DataSource dataSourceProxy = null;
    protected AbstractTypeMap typeMap;
    private boolean hasTransaction;
    private Map<String, TableMeta> metas = new HashMap<String, TableMeta>();

    protected AbstractDBEnvironment(DataSourceType dataSourceType, String dataSourceName, String dataSourceFrom) {
        TypeAdapter.registerParseDelegate(BigDecimal.class, BigDecimalParseDelegate.class);
        TypeAdapter.registerParseDelegate(Date.class, SqlDateParseDelegate.class);
        TypeAdapter.registerParseDelegate(Timestamp.class, SqlTimestampParseDelegate.class);
        this.dataSourceName = dataSourceName;
        this.dataSourceFrom = dataSourceFrom;
        this.dataSourceType = dataSourceType;
    }

    public void setDataSource(String driver, String url, String schemas, String username, String password) {
        this.jtesterDataSource = new JTesterDataSource(this.dataSourceType, driver, url, schemas, username, password);
    }

    public DataSource getDataSource(boolean withTransactionManager) {
        this.dataSourceProxy = this.jtesterDataSource;
        if (withTransactionManager) {
            this.dataSourceProxy = new TransactionAwareDataSourceProxy((DataSource)this.jtesterDataSource);
        }
        return this.dataSourceProxy;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.commit();
                DataSourceUtils.doReleaseConnection((Connection)this.connection, (DataSource)this.dataSourceProxy);
                this.connection = null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("close datasource[%s] connection error.", this.jtesterDataSource.toString()), e);
        }
    }

    public Connection connect() throws SQLException {
        this.hasTransaction = false;
        DbFitContext.RunIn runIn = DbFitContext.getRunIn();
        if (runIn == DbFitContext.RunIn.TestCase) {
            boolean springAvailable = ClazzHelper.isClassAvailable("org.springframework.jdbc.datasource.DataSourceUtils");
            this.hasTransaction = springAvailable && TestedObject.isTransactionsEnabled();
        }
        this.dataSourceProxy = this.getDataSource(this.hasTransaction);
        this.connection = DataSourceUtils.doGetConnection((DataSource)this.dataSourceProxy);
        if (this.connection == null || this.connection.isClosed()) {
            System.out.println();
        }
        this.connection.setAutoCommit(false);
        return this.connection;
    }

    public final void teardown() throws SQLException {
        boolean isDefaultDbEnv = this.isDefaultDBEnvironment();
        if (!isDefaultDbEnv || !this.hasTransaction || this.connection == null) {
            this.commit();
            DataSourceUtils.doReleaseConnection((Connection)this.connection, (DataSource)this.dataSourceProxy);
            this.connection = null;
        }
    }

    private boolean isDefaultDBEnvironment() {
        boolean isDefault = "DEFAULT".equals(this.dataSourceName) && "JTESTER-PROPERTIES".equals(this.dataSourceFrom);
        return isDefault;
    }

    protected String parseCommandText(String commandText, String[] vars) {
        return commandText;
    }

    public final PreparedStatement createStatementWithBoundFixtureSymbols(String commandText) throws SQLException {
        String text = SymbolUtil.replacedBySymbols(commandText);
        String[] paramNames = this.extractParamNames(text);
        String sql = this.parseCommandText(text, paramNames);
        PreparedStatement cs = this.connection.prepareStatement(sql);
        for (int i = 0; i < paramNames.length; ++i) {
            Object value = SymbolUtil.getSymbol(paramNames[i]);
            cs.setObject(i + 1, value);
        }
        return cs;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.commit();
            this.connection.setAutoCommit(false);
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.rollback();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getExceptionCode(SQLException dbException) {
        return dbException.getErrorCode();
    }

    public String[] extractParamNames(String commandText) {
        ArrayList<String> hs = new ArrayList<String>();
        Matcher mc = this.getParameterPattern().matcher(commandText);
        while (mc.find()) {
            String var = mc.group(1);
            if (!SymbolUtil.hasSymbol(var)) continue;
            hs.add(var);
        }
        String[] array = new String[hs.size()];
        return hs.toArray(array);
    }

    protected abstract Pattern getParameterPattern();

    public String buildInsertCommand(String tableName, DbParameterAccessor[] accessors) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(tableName).append("(");
        String comma = "";
        StringBuilder values = new StringBuilder();
        for (DbParameterAccessor accessor : accessors) {
            if (accessor.getDirection() != 1) continue;
            sb.append(comma);
            values.append(comma);
            sb.append(this.getFieldQuato()).append(accessor.getName()).append(this.getFieldQuato());
            values.append("?");
            comma = ",";
        }
        sb.append(") values (");
        sb.append((CharSequence)values);
        sb.append(")");
        return sb.toString();
    }

    public String buildDeleteCommand(String tableName, DbParameterAccessor[] accessors) {
        StringBuilder sb = new StringBuilder("delete from " + tableName + " where ");
        String comma = "";
        for (DbParameterAccessor accessor : accessors) {
            if (accessor.getDirection() != 1) continue;
            sb.append(comma);
            sb.append(accessor.getName());
            sb.append("=?");
            comma = ",";
        }
        return sb.toString();
    }

    public boolean supportsOuputOnInsert() {
        return false;
    }

    public static void checkConnectionValid(Connection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("No open connection to a database is available. Make sure your database is running and that you have connected before performing any queries.");
        }
    }

    public Connection connectIfNeeded() {
        try {
            Connection conn = this.getConnection();
            if (conn == null || conn.isClosed()) {
                conn = this.connect();
            }
            return conn;
        }
        catch (Exception e) {
            throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
        }
    }

    public TableMeta getTableMetaData(String table) {
        TableMeta meta = this.metas.get(table);
        if (meta == null) {
            try {
                this.connectIfNeeded();
                String query = "select * from " + table + " where 1!=1";
                PreparedStatement st = this.createStatementWithBoundFixtureSymbols(query);
                ResultSet rs = st.executeQuery();
                meta = new TableMeta(table, rs.getMetaData(), this);
                this.metas.put(table, meta);
            }
            catch (Exception e) {
                throw ExceptionWrapper.getUndeclaredThrowableExceptionCaused(e);
            }
        }
        return meta;
    }

    public Object getDefaultValue(String javaType) {
        Object value = this.typeMap.getDefaultValue(javaType);
        return value;
    }

    public Object toObjectValue(String input, String javaType) {
        try {
            Object value = this.typeMap.toObjectByType(input, javaType);
            return value;
        }
        catch (Exception e) {
            JTesterLogger.info("convert input[" + input + "] to type[" + javaType + "] error, so return input value.\n" + e.getMessage());
            return input;
        }
    }
}

