/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.jtester.module.core.helper.ConfigurationHelper;
import org.jtester.module.database.environment.DBEnvironment;
import org.jtester.module.database.environment.impl.DerbyEnvironment;
import org.jtester.module.database.environment.impl.MySqlEnvironment;
import org.jtester.module.database.environment.impl.OracleEnvironment;
import org.jtester.module.database.environment.impl.SqlServerEnvironment;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.utility.ResourceHelper;
import org.jtester.utility.StringHelper;

public final class DBEnvironmentFactory {
    private static Map<String, DBEnvironment> environments = new HashMap<String, DBEnvironment>();
    static final String NO_VALID_VALUE_MESSAGE = "can't find valid value of key[%s] in file[%s]!";
    private static DBEnvironment currDBEnvironment = null;

    private static DBEnvironment newInstance(DataSourceType dataSourceType, String dataSourceName, String dataSourceFrom) {
        if (dataSourceType == null) {
            throw new RuntimeException("DatabaseType can't be null.");
        }
        switch (dataSourceType) {
            case MYSQL: {
                return new MySqlEnvironment(dataSourceName, dataSourceFrom);
            }
            case ORACLE: {
                return new OracleEnvironment(dataSourceName, dataSourceFrom);
            }
            case SQLSERVER: {
                return new SqlServerEnvironment(dataSourceName, dataSourceFrom);
            }
            case DERBYDB: {
                return new DerbyEnvironment(dataSourceName, dataSourceFrom);
            }
        }
        throw new RuntimeException("unsupport database type:" + dataSourceType.name());
    }

    public static DBEnvironment getDBEnvironment(String type, String driver, String url, String username, String password) {
        DataSourceType dataSourceType = DataSourceType.databaseType(type);
        String dataSourceFrom = "customized-" + UUID.randomUUID().toString();
        DBEnvironment enviroment = DBEnvironmentFactory.newInstance(dataSourceType, "CUSTOMIZED", dataSourceFrom);
        environments.put("DEFAULT=" + dataSourceFrom, enviroment);
        if (StringHelper.isBlankOrNull(driver)) {
            driver = ConfigurationHelper.databaseDriver();
        }
        if (StringHelper.isBlankOrNull(url)) {
            url = ConfigurationHelper.databaseUrl();
        }
        if (StringHelper.isBlankOrNull(username)) {
            username = ConfigurationHelper.databaseUserName();
        }
        if (StringHelper.isBlankOrNull(password)) {
            password = ConfigurationHelper.databasePassword();
        }
        enviroment.setDataSource(driver, url, "", username, password);
        return enviroment;
    }

    public static DBEnvironment getDBEnvironment() {
        DBEnvironment enviroment = DBEnvironmentFactory.getDBEnvironment("DEFAULT", "JTESTER-PROPERTIES");
        return enviroment;
    }

    public static DBEnvironment getDBEnvironment(String dataSourceName) {
        if (StringHelper.isBlankOrNull(dataSourceName)) {
            dataSourceName = "DEFAULT";
        }
        DBEnvironment enviroment = DBEnvironmentFactory.getDBEnvironment(dataSourceName, "JTESTER-PROPERTIES");
        return enviroment;
    }

    public static DBEnvironment getDBEnvironment(String dataSourceName, String dataSourceFrom) {
        dataSourceName = StringHelper.isBlankOrNull(dataSourceName) ? "DEFAULT" : dataSourceName;
        dataSourceFrom = StringHelper.isBlankOrNull(dataSourceFrom) ? "JTESTER-PROPERTIES" : dataSourceFrom;
        DBEnvironment enviroment = environments.get(dataSourceName + "=" + dataSourceFrom);
        if (enviroment == null) {
            String schemas;
            Properties props = null;
            if (!StringHelper.isBlankOrNull(dataSourceFrom) && !"JTESTER-PROPERTIES".equalsIgnoreCase(dataSourceFrom)) {
                props = ResourceHelper.loadPropertiesFrom(dataSourceFrom);
            }
            String typeProperty = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.type"));
            DataSourceType dataSourceType = DataSourceType.databaseType(typeProperty);
            enviroment = DBEnvironmentFactory.newInstance(dataSourceType, dataSourceName, dataSourceFrom);
            environments.put(dataSourceName + "=" + dataSourceFrom, enviroment);
            String driver = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.driverClassName"));
            String url = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.url"));
            String user = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.userName"));
            if (StringHelper.isBlankOrNull(driver) || StringHelper.isBlankOrNull(url) || StringHelper.isBlankOrNull(user)) {
                throw new RuntimeException(String.format(NO_VALID_VALUE_MESSAGE, dataSourceName + "." + "database.userName", dataSourceFrom));
            }
            String pass = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.password"));
            if (pass == null) {
                pass = "";
            }
            schemas = (schemas = ConfigurationHelper.getString(props, DBEnvironmentFactory.getMergeKey(dataSourceName, "database.schemaNames"), "")) == null ? "" : schemas;
            enviroment.setDataSource(driver, url, schemas, user, pass);
        }
        return enviroment;
    }

    private static String getMergeKey(String dataSourceName, String key) {
        if (StringHelper.isBlankOrNull(dataSourceName) || "DEFAULT".equalsIgnoreCase(dataSourceName)) {
            return key;
        }
        return dataSourceName + "." + key;
    }

    public static void commitCurrentDBEnvironment() {
        if (currDBEnvironment == null) {
            return;
        }
        currDBEnvironment.close();
    }

    public static DBEnvironment getCurrentDBEnvironment() {
        if (currDBEnvironment == null) {
            currDBEnvironment = DBEnvironmentFactory.getDBEnvironment();
        }
        return currDBEnvironment;
    }

    public static void changeDBEnvironment(DBEnvironment environment) {
        if (currDBEnvironment != null && !currDBEnvironment.equals(environment)) {
            currDBEnvironment.close();
        }
        currDBEnvironment = environment;
    }

    public static void changeDBEnvironment(String dataSourceName) {
        if (StringHelper.isBlankOrNull(dataSourceName)) {
            dataSourceName = "DEFAULT";
        }
        DBEnvironment specEnvironment = DBEnvironmentFactory.getDBEnvironment(dataSourceName);
        DBEnvironmentFactory.changeDBEnvironment(specEnvironment);
    }

    public static void endTransactional() {
        StringBuilder err = new StringBuilder();
        for (DBEnvironment environment : environments.values()) {
            try {
                Connection conn = environment.getConnection();
                if (conn == null || conn.isClosed()) continue;
                environment.rollback();
                environment.close();
            }
            catch (Throwable e) {
                err.append(StringHelper.exceptionTrace(e));
            }
        }
        String msg = err.toString();
        if (!"".equalsIgnoreCase(msg.trim())) {
            throw new RuntimeException(msg);
        }
    }
}

