/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment;

import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jtester.module.database.environment.DBEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMeta {
    String tableName;
    Map<String, ColumnMeta> columns;

    public TableMeta(String table, ResultSetMetaData meta, DBEnvironment dbEnvironment) throws Exception {
        this.tableName = table;
        this.columns = new HashMap<String, ColumnMeta>();
        int count = meta.getColumnCount();
        for (int index = 1; index <= count; ++index) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.columnName = meta.getColumnName(index);
            columnMeta.size = meta.getColumnDisplaySize(index);
            columnMeta.typeName = meta.getColumnTypeName(index);
            columnMeta.isNullable = meta.isNullable(index) == 1;
            columnMeta.javaType = meta.getColumnClassName(index);
            this.columns.put(columnMeta.columnName, columnMeta);
        }
    }

    public Map<String, ColumnMeta> getColumns() {
        return this.columns;
    }

    public String getColumnType(String column) {
        ColumnMeta meta = this.getColumns().get(column);
        if (meta == null) {
            throw new RuntimeException("can't find column[" + column + "] field in table[" + this.tableName + "].");
        }
        return meta.javaType;
    }

    public int getCloumnSize(String column) {
        ColumnMeta meta = this.getColumns().get(column);
        if (meta == null) {
            throw new RuntimeException("can't find column[" + column + "] field in table[" + this.tableName + "].");
        }
        return meta.size;
    }

    public String truncateString(String column, String input) {
        if (input == null) {
            return null;
        }
        int size = this.getCloumnSize(column);
        if (size > input.length()) {
            return input;
        }
        return input.substring(0, size);
    }

    public void fillData(Map<String, Object> data, DBEnvironment dbEnvironment) {
        Set<String> keys = data.keySet();
        for (String key : this.columns.keySet()) {
            if (keys.contains(key)) continue;
            ColumnMeta column = this.columns.get(key);
            Object value = column.getDefaultValue(dbEnvironment);
            data.put(key, value);
        }
    }

    public static class ColumnMeta {
        String columnName;
        int size;
        String typeName;
        boolean isNullable;
        Object defaultValue;
        String javaType;

        public String toString() {
            return "[columnName=" + this.columnName + ", size=" + this.size + ", typeName=" + this.typeName + ", isNullable=" + this.isNullable + ", defaultValue=" + this.defaultValue + "]";
        }

        public Object getDefaultValue(DBEnvironment dbEnvironment) {
            if (this.isNullable()) {
                return null;
            }
            if ("java.lang.String".equals(this.javaType)) {
                return "jtester".subSequence(0, this.size > 7 ? 7 : this.size);
            }
            Object value = dbEnvironment.getDefaultValue(this.javaType);
            return value;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public int getSize() {
            return this.size;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }
}

