/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jtester.module.database.environment.AbstractDBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2Environment
extends AbstractDBEnvironment {
    private static String paramNamePattern = "[@:]([A-Za-z0-9_]+)";
    private static Pattern paramRegex = Pattern.compile(paramNamePattern);
    private static List<String> stringTypes = Arrays.asList("VARCHAR", "CHAR", "CHARACTER", "GRAPHIC", "VARGRAPHIC");
    private static List<String> intTypes = Arrays.asList("SMALLINT", "INT", "INTEGER");
    private static List<String> longTypes = Arrays.asList("BIGINT");
    private static List<String> floatTypes = Arrays.asList("FLOAT");
    private static List<String> doubleTypes = Arrays.asList("DOUBLE");
    private static List<String> decimalTypes = Arrays.asList("DECIMAL", "DEC");
    private static List<String> dateTypes = Arrays.asList("DATE");
    private static List<String> timestampTypes = Arrays.asList("TIMESTAMP");

    public DB2Environment(String dataSourceName, String dataSourceFrom) {
        super(DataSourceType.DB2, dataSourceName, dataSourceFrom);
        this.typeMap = null;
    }

    @Override
    protected String parseCommandText(String commandText, String[] vars) {
        if (vars == null || vars.length == 0) {
            return commandText;
        }
        String sql = commandText;
        for (String var : vars) {
            sql = sql.replace("@" + var, "?").replace(":" + var, "?");
        }
        return sql;
    }

    @Override
    public Pattern getParameterPattern() {
        return paramRegex;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllColumns(String tableOrViewName) throws SQLException {
        String[] qualifiers = NameNormaliser.normaliseName(tableOrViewName).split("\\.");
        String qry = " select colname as column_name, typename as data_type, length, \t'P' as direction from syscat.columns where ";
        qry = qualifiers.length == 2 ? qry + " lower(tabschema)=? and lower(tabname)=? " : qry + " (lower(tabname)=?)";
        qry = qry + " order by colname";
        return this.readIntoParams(qualifiers, qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbParameterAccessor> readIntoParams(String[] queryParameters, String query) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        PreparedStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareStatement(query);
            for (int i = 0; i < queryParameters.length; ++i) {
                dc.setString(i + 1, NameNormaliser.normaliseName(queryParameters[i]));
            }
            rs = dc.executeQuery();
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            int position = 0;
            while (rs.next()) {
                String paramName = rs.getString(1);
                if (paramName == null) {
                    paramName = "";
                }
                String dataType = rs.getString(2);
                String direction = rs.getString(4);
                int paramDirection = DB2Environment.getParameterDirection(direction);
                DbParameterAccessor dbp = new DbParameterAccessor(paramName, paramDirection, DB2Environment.getSqlType(dataType), this.getJavaClass(dataType), paramDirection == 0 ? -1 : position++);
                allParams.put(NameNormaliser.normaliseName(paramName), dbp);
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    private static int getParameterDirection(String direction) {
        if ("P".equals(direction)) {
            return 1;
        }
        if ("O".equals(direction)) {
            return 2;
        }
        if ("B".equals(direction)) {
            return 3;
        }
        if ("C".equals(direction)) {
            return 0;
        }
        throw new UnsupportedOperationException("Direction " + direction + " is not supported");
    }

    private static String NormaliseTypeName(String dataType) {
        dataType = dataType.toUpperCase().trim();
        return dataType;
    }

    private static int getSqlType(String dataType) {
        if (stringTypes.contains(dataType = DB2Environment.NormaliseTypeName(dataType))) {
            return 12;
        }
        if (decimalTypes.contains(dataType)) {
            return 2;
        }
        if (intTypes.contains(dataType)) {
            return 4;
        }
        if (floatTypes.contains(dataType)) {
            return 6;
        }
        if (doubleTypes.contains(dataType)) {
            return 8;
        }
        if (longTypes.contains(dataType)) {
            return -5;
        }
        if (timestampTypes.contains(dataType)) {
            return 93;
        }
        if (dateTypes.contains(dataType)) {
            return 91;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Class getJavaClass(String dataType) {
        if (stringTypes.contains(dataType = DB2Environment.NormaliseTypeName(dataType))) {
            return String.class;
        }
        if (decimalTypes.contains(dataType)) {
            return BigDecimal.class;
        }
        if (intTypes.contains(dataType)) {
            return Integer.class;
        }
        if (floatTypes.contains(dataType)) {
            return Float.class;
        }
        if (dateTypes.contains(dataType)) {
            return Date.class;
        }
        if (doubleTypes.contains(dataType)) {
            return Double.class;
        }
        if (longTypes.contains(dataType)) {
            return Long.class;
        }
        if (timestampTypes.contains(dataType)) {
            return Timestamp.class;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Map<String, DbParameterAccessor> getAllProcedureParameters(String procName) throws SQLException {
        String[] qualifiers = NameNormaliser.normaliseName(procName).split("\\.");
        String qry = " select parmname as column_name, typename as data_type, length, \trowtype as direction, ordinal from SYSIBM.SYSroutinePARMS  where ";
        qry = qualifiers.length == 2 ? qry + " lower(routineschema)=? and lower(routinename)=? " : qry + " (lower(routinename)=?)";
        qry = qry + " order by ordinal";
        return this.readIntoParams(qualifiers, qry);
    }

    @Override
    public String getFieldQuato() {
        return "";
    }
}

