/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jtester.module.database.environment.AbstractDBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyEnvironment
extends AbstractDBEnvironment {
    private TypeMapper typeMapper = new DerbyTypeMapper();
    private static final String paramNamePattern = "@([A-Za-z0-9_]+)";
    private static final Pattern paramRegex = Pattern.compile("@([A-Za-z0-9_]+)");

    public DerbyEnvironment(String dataSourceName, String dataSourceFrom) {
        super(DataSourceType.DERBYDB, dataSourceName, dataSourceFrom);
        this.typeMap = null;
    }

    @Override
    public Pattern getParameterPattern() {
        return paramRegex;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllColumns(String tableOrViewName) throws SQLException {
        String qry = "SELECT COLUMNNAME, COLUMNDATATYPE FROM SYS.SYSCOLUMNS WHERE REFERENCEID = (SELECT TABLEID FROM SYS.SYSTABLES WHERE TABLENAME = ?)";
        return this.readIntoParams(tableOrViewName, qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbParameterAccessor> readIntoParams(String tableOrViewName, String query) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        DerbyEnvironment.checkConnectionValid(this.connection);
        PreparedStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareStatement(query);
            dc.setString(1, tableOrViewName);
            rs = dc.executeQuery();
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            int position = 0;
            while (rs.next()) {
                String columnName = rs.getString(1);
                String dataType = rs.getString(2);
                DbParameterAccessor dbp = new DbParameterAccessor(columnName, 1, this.typeMapper.getJDBCSQLTypeForDBType(dataType), this.getJavaClass(dataType), position++);
                allParams.put(NameNormaliser.normaliseName(columnName), dbp);
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllProcedureParameters(String procName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getJavaClass(String dataType) {
        return this.typeMapper.getJavaClassForDBType(dataType);
    }

    @Override
    public String getFieldQuato() {
        return "";
    }

    public static class DerbyTypeMapper
    implements TypeMapper {
        private static final List<String> stringTypes = Arrays.asList("CHAR", "CHARACTER", "LONG VARCHAR", "VARCHAR", "XML", "CHAR VARYING", "CHARACTER VARYING", "LONG VARCHAR FOR BIT DATA", "VARCHAR FOR BIT DATA");
        private static final List<String> intTypes = Arrays.asList("INTEGER", "INT");
        private static final List<String> longTypes = Arrays.asList("BIGINT");
        private static final List<String> doubleTypes = Arrays.asList("DOUBLE", "DOUBLE PRECISION", "FLOAT");
        private static final List<String> floatTypes = Arrays.asList("REAL");
        private static final List<String> shortTypes = Arrays.asList("SMALLINT");
        private static final List<String> decimalTypes = Arrays.asList("DECIMAL", "DEC", "NUMERIC");
        private static final List<String> dateTypes = Arrays.asList("DATE");
        private static final List<String> timestampTypes = Arrays.asList("TIMESTAMP");
        private static final List<String> timeTypes = Arrays.asList("TIME");

        public Class getJavaClassForDBType(String dbDataType) {
            String dataType = DerbyTypeMapper.normaliseTypeName(dbDataType);
            if (stringTypes.contains(dataType)) {
                return String.class;
            }
            if (decimalTypes.contains(dataType)) {
                return BigDecimal.class;
            }
            if (intTypes.contains(dataType)) {
                return Integer.class;
            }
            if (timeTypes.contains(dataType)) {
                return Time.class;
            }
            if (dateTypes.contains(dataType)) {
                return Date.class;
            }
            if (floatTypes.contains(dataType)) {
                return Float.class;
            }
            if (shortTypes.contains(dataType)) {
                return Short.class;
            }
            if (doubleTypes.contains(dataType)) {
                return Double.class;
            }
            if (longTypes.contains(dataType)) {
                return Long.class;
            }
            if (timestampTypes.contains(dataType)) {
                return Timestamp.class;
            }
            throw new UnsupportedOperationException("Type '" + dbDataType + "' is not supported for Derby");
        }

        public int getJDBCSQLTypeForDBType(String dbDataType) {
            String dataType = DerbyTypeMapper.normaliseTypeName(dbDataType);
            if (stringTypes.contains(dataType)) {
                return 12;
            }
            if (decimalTypes.contains(dataType)) {
                return 3;
            }
            if (intTypes.contains(dataType) || shortTypes.contains(dataType)) {
                return 4;
            }
            if (floatTypes.contains(dataType)) {
                return 6;
            }
            if (doubleTypes.contains(dataType)) {
                return 8;
            }
            if (longTypes.contains(dataType)) {
                return -5;
            }
            if (timestampTypes.contains(dataType)) {
                return 93;
            }
            if (timeTypes.contains(dataType)) {
                return 92;
            }
            if (dateTypes.contains(dataType)) {
                return 91;
            }
            throw new UnsupportedOperationException("Type '" + dbDataType + "' is not supported for Derby");
        }

        private static String normaliseTypeName(String type) {
            if (type != null && !"".equals(type)) {
                String dataType = type.toUpperCase().trim();
                int idxLeftPara = dataType.indexOf(40);
                if (idxLeftPara > 0) {
                    dataType = dataType.substring(0, idxLeftPara);
                }
                if ((idxLeftPara = dataType.indexOf(" NOT NULL")) > 0) {
                    dataType = dataType.substring(0, idxLeftPara);
                }
                if ((idxLeftPara = dataType.indexOf(" NULL")) > 0) {
                    dataType = dataType.substring(0, idxLeftPara);
                }
                return dataType;
            }
            throw new IllegalArgumentException("You must specify a valid type for conversions");
        }
    }

    static interface TypeMapper {
        public Class getJavaClassForDBType(String var1);

        public int getJDBCSQLTypeForDBType(String var1);
    }
}

