/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jtester.module.database.environment.AbstractDBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.environment.typesmap.MySQLTypeMap;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlEnvironment
extends AbstractDBEnvironment {
    private static String paramNamePattern = "@([A-Za-z0-9_]+)";
    private static Pattern paramRegex = Pattern.compile(paramNamePattern);

    public MySqlEnvironment(String dataSourceName, String dataSourceFrom) {
        super(DataSourceType.MYSQL, dataSourceName, dataSourceFrom);
        this.typeMap = new MySQLTypeMap();
    }

    @Override
    public boolean supportsOuputOnInsert() {
        return false;
    }

    @Override
    public Pattern getParameterPattern() {
        return paramRegex;
    }

    @Override
    protected String parseCommandText(String commandText, String[] vars) {
        if (vars == null || vars.length == 0) {
            return commandText;
        }
        String sql = commandText;
        for (String var : vars) {
            sql = sql.replace("@" + var, "?");
        }
        return sql;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllColumns(String tableOrViewName) throws SQLException {
        String[] qualifiers = NameNormaliser.normaliseName(tableOrViewName).split("\\.");
        String qry = " select column_name, data_type, character_maximum_length \tas direction from information_schema.columns where ";
        qry = qualifiers.length == 2 ? qry + " lower(table_schema)=? and lower(table_name)=? " : qry + " (table_schema=database() and lower(table_name)=?)";
        qry = qry + " order by ordinal_position";
        return this.readIntoParams(qualifiers, qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbParameterAccessor> readIntoParams(String[] queryParameters, String query) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        PreparedStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareStatement(query);
            for (int i = 0; i < queryParameters.length; ++i) {
                dc.setString(i + 1, NameNormaliser.normaliseName(queryParameters[i]));
            }
            rs = dc.executeQuery();
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            int position = 0;
            while (rs.next()) {
                String paramName = rs.getString(1);
                if (paramName == null) {
                    paramName = "";
                }
                String dataType = rs.getString(2);
                DbParameterAccessor dbp = new DbParameterAccessor(paramName, 1, MySqlEnvironment.getSqlType(dataType), this.getJavaClass(dataType), position++);
                allParams.put(NameNormaliser.normaliseName(paramName), dbp);
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    private static String normaliseTypeName(String dataType) {
        return dataType.toUpperCase().trim();
    }

    private static int getSqlType(String dataType) {
        Integer type = MySQLTypeMap.getSQLType(dataType = MySqlEnvironment.normaliseTypeName(dataType));
        if (type != null) {
            return type;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Class getJavaClass(String dataType) {
        Class clazz = MySQLTypeMap.getJavaType(dataType = MySqlEnvironment.normaliseTypeName(dataType));
        if (clazz != null) {
            return clazz;
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DbParameterAccessor> getAllProcedureParameters(String procName) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        String[] qualifiers = NameNormaliser.normaliseName(procName).split("\\.");
        String qry = " select type,param_list,returns from mysql.proc where ";
        qry = qualifiers.length == 2 ? qry + " lower(db)=? and lower(name)=? " : qry + " (db=database() and lower(name)=?)";
        PreparedStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareStatement(qry);
            for (int i = 0; i < qualifiers.length; ++i) {
                dc.setString(i + 1, NameNormaliser.normaliseName(qualifiers[i]));
            }
            rs = dc.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Unknown procedure " + procName);
            }
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            String type = rs.getString(1);
            String paramList = rs.getString(2);
            String returns = rs.getString(3);
            int position = 0;
            for (String param : paramList.split(",")) {
                StringTokenizer s = new StringTokenizer(param.trim().toLowerCase(), " ()");
                String token = s.nextToken();
                int direction = 1;
                if (token.equals("inout")) {
                    direction = 3;
                    token = s.nextToken();
                }
                if (token.equals("in")) {
                    token = s.nextToken();
                } else if (token.equals("out")) {
                    direction = 2;
                    token = s.nextToken();
                }
                String paramName = token;
                String dataType = s.nextToken();
                DbParameterAccessor dbp = new DbParameterAccessor(paramName, direction, MySqlEnvironment.getSqlType(dataType), this.getJavaClass(dataType), position++);
                allParams.put(NameNormaliser.normaliseName(paramName), dbp);
            }
            if ("FUNCTION".equals(type)) {
                StringTokenizer s = new StringTokenizer(returns.trim().toLowerCase(), " ()");
                String dataType = s.nextToken();
                allParams.put("", new DbParameterAccessor("", 0, MySqlEnvironment.getSqlType(dataType), this.getJavaClass(dataType), -1));
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    @Override
    public String getFieldQuato() {
        return "`";
    }
}

