/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.impl;

import ext.jtester.org.apache.commons.io.IOUtils;
import fit.TypeAdapter;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import org.jtester.module.database.environment.AbstractDBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.environment.normalise.TypeNormaliser;
import org.jtester.module.database.environment.normalise.TypeNormaliserFactory;
import org.jtester.module.database.environment.typesmap.OracleTypeMap;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;
import org.jtester.module.dbfit.db.model.OracleBlobTypeAdapter;
import org.jtester.module.dbfit.db.model.SqlTimestampParseDelegate;
import org.jtester.utility.ResourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleEnvironment
extends AbstractDBEnvironment {
    private static Pattern paramsNames = Pattern.compile(":([A-Za-z0-9_]+)");

    public OracleEnvironment(String dataSourceName, String dataSourceFrom) {
        super(DataSourceType.ORACLE, dataSourceName, dataSourceFrom);
        TypeNormaliserFactory.setNormaliser(TIMESTAMP.class, new OracleTimestampNormaliser());
        TypeNormaliserFactory.setNormaliser(DATE.class, new OracleDateNormaliser());
        TypeNormaliserFactory.setNormaliser(CLOB.class, new OracleClobNormaliser());
        TypeNormaliserFactory.setNormaliser(BLOB.class, new OracleBlobNormaliser());
        TypeNormaliserFactory.setNormaliser(Date.class, new SqlDateNormaliser());
        TypeAdapter.registerParseDelegate(BLOB.class, OracleBlobTypeAdapter.class);
        try {
            TypeNormaliserFactory.setNormaliser(Class.forName("oracle.jdbc.driver.OracleResultSetImpl"), new OracleRefNormaliser());
        }
        catch (Throwable e) {
            throw new Error("Cannot initialise oracle rowset", e);
        }
        this.typeMap = new OracleTypeMap();
    }

    @Override
    public boolean supportsOuputOnInsert() {
        return true;
    }

    @Override
    public Pattern getParameterPattern() {
        return paramsNames;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllProcedureParameters(String procName) throws SQLException {
        String[] qualifiers = NameNormaliser.normaliseName(procName).split("\\.");
        String cols = " argument_name, data_type, data_length,  IN_OUT, sequence ";
        String qry = "select " + cols + "  from all_arguments where data_level=0 and ";
        qry = qualifiers.length == 3 ? qry + " owner=? and package_name=? and object_name=? " : (qualifiers.length == 2 ? qry + " ((owner=? and package_name is null and object_name=?) or  (owner=user and package_name=? and object_name=?))" : qry + " (owner=user and package_name is null and object_name=?)");
        if (qualifiers.length < 3) {
            qry = qry + " union all  select " + cols + " from all_arguments, all_synonyms " + " where data_level=0 and all_synonyms.owner='PUBLIC' and all_arguments.owner=table_owner and ";
            qry = qualifiers.length == 2 ? qry + " package_name=table_name and synonym_name=? and object_name=? " : qry + " package_name is null and object_name=table_name and synonym_name=? ";
        }
        qry = qry + " order by sequence ";
        if (qualifiers.length == 2) {
            String[] newQualifiers = new String[]{qualifiers[0], qualifiers[1], qualifiers[0], qualifiers[1], qualifiers[0], qualifiers[1]};
            qualifiers = newQualifiers;
        } else if (qualifiers.length == 1) {
            String[] newQualifiers = new String[]{qualifiers[0], qualifiers[0]};
            qualifiers = newQualifiers;
        }
        return this.readIntoParams(qualifiers, qry);
    }

    @Override
    public Map<String, DbParameterAccessor> getAllColumns(String tableOrViewName) throws SQLException {
        String[] qualifiers = NameNormaliser.normaliseName(tableOrViewName).split("\\.");
        String qry = " select column_name, data_type, data_length,  'IN' as direction, column_id from all_tab_columns where ";
        qry = qualifiers.length == 2 ? qry + " owner=? and table_name=? " : qry + " (owner=user and table_name=?)";
        qry = qry + " order by column_id ";
        return this.readIntoParams(qualifiers, qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbParameterAccessor> readIntoParams(String[] queryParameters, String query) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        CallableStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareCall(query);
            for (int i = 0; i < queryParameters.length; ++i) {
                dc.setString(i + 1, queryParameters[i].toUpperCase());
            }
            rs = dc.executeQuery();
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            int position = 0;
            while (rs.next()) {
                String paramName = rs.getString(1);
                if (paramName == null) {
                    paramName = "";
                }
                String dataType = rs.getString(2);
                String direction = rs.getString(4);
                int paramDirection = paramName.trim().length() == 0 ? 0 : OracleEnvironment.getParameterDirection(direction);
                DbParameterAccessor dbp = new DbParameterAccessor(paramName, paramDirection, OracleEnvironment.getSqlType(dataType), this.getJavaClass(dataType), paramDirection == 0 ? -1 : position++);
                allParams.put(NameNormaliser.normaliseName(paramName), dbp);
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    private static String normaliseTypeName(String dataType) {
        int idx = (dataType = dataType.toUpperCase().trim()).indexOf(" ");
        if (idx >= 0) {
            dataType = dataType.substring(0, idx);
        }
        if ((idx = dataType.indexOf("(")) >= 0) {
            dataType = dataType.substring(0, idx);
        }
        return dataType;
    }

    private static int getSqlType(String dataType) {
        Integer type = OracleTypeMap.getSQLType(dataType = OracleEnvironment.normaliseTypeName(dataType));
        if (type != null) {
            return type;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Class getJavaClass(String dataType) {
        Class clazz = OracleTypeMap.getJavaType(dataType = OracleEnvironment.normaliseTypeName(dataType));
        if (clazz != null) {
            return clazz;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    private static int getParameterDirection(String direction) {
        if ("IN".equals(direction)) {
            return 1;
        }
        if ("OUT".equals(direction)) {
            return 2;
        }
        if ("IN/OUT".equals(direction)) {
            return 3;
        }
        throw new UnsupportedOperationException("Direction " + direction + " is not supported");
    }

    @Override
    public String buildInsertCommand(String tableName, DbParameterAccessor[] accessors) {
        StringBuilder sb = new StringBuilder("begin insert into ");
        sb.append(tableName).append("(");
        String comma = "";
        String retComma = "";
        StringBuilder values = new StringBuilder();
        StringBuilder retNames = new StringBuilder();
        StringBuilder retValues = new StringBuilder();
        for (DbParameterAccessor accessor : accessors) {
            int direction = accessor.getDirection();
            if (direction == 1 || direction == 4) {
                sb.append(comma);
                values.append(comma);
                sb.append(accessor.getName());
                values.append(accessor.getPlaceholder());
                comma = ",";
            }
            if (direction != 2 && direction != 4 && direction != 3) continue;
            retNames.append(retComma);
            retValues.append(retComma);
            retNames.append(accessor.getName());
            retValues.append("?");
            retComma = ",";
        }
        sb.append(") values (");
        sb.append((CharSequence)values);
        sb.append(")");
        if (retValues.length() > 0) {
            sb.append(" returning ").append((CharSequence)retNames).append(" into ").append((CharSequence)retValues);
        }
        sb.append("; end;");
        return sb.toString();
    }

    @Override
    public String getFieldQuato() {
        return "\"";
    }

    public static class OracleRefNormaliser
    implements TypeNormaliser {
        public Object normalise(Object o) throws SQLException {
            block4: {
                OracleCachedRowSet oracleCachedRowSet;
                if (o == null) {
                    return null;
                }
                ResultSet rs = null;
                try {
                    if (!(o instanceof ResultSet)) break block4;
                    rs = (ResultSet)o;
                    OracleCachedRowSet ocrs = new OracleCachedRowSet();
                    ocrs.populate(rs);
                    oracleCachedRowSet = ocrs;
                }
                catch (Throwable throwable) {
                    DBHelper.closeResultSet(rs);
                    rs = null;
                    throw throwable;
                }
                DBHelper.closeResultSet(rs);
                rs = null;
                return oracleCachedRowSet;
            }
            String err = "OracleRefNormaliser cannot work on " + o.getClass();
            throw new UnsupportedOperationException(err);
        }
    }

    public static class OracleBlobNormaliser
    implements TypeNormaliser {
        private static final int MAX_CLOB_LENGTH = 10000;

        public Object normalise(Object o) throws Exception {
            if (o == null) {
                return null;
            }
            if (!(o instanceof BLOB)) {
                throw new UnsupportedOperationException("OracleClobNormaliser cannot work with " + o.getClass());
            }
            BLOB blob = (BLOB)o;
            if (blob.length() > 10000L) {
                throw new UnsupportedOperationException("Clobs larger than 10000bytes are not supported by DBFIT");
            }
            char[] base64 = IOUtils.toCharArray(blob.getBinaryStream());
            String value = new String(base64);
            return value;
        }
    }

    public static class OracleClobNormaliser
    implements TypeNormaliser {
        private static final int MAX_CLOB_LENGTH = 10000;

        public Object normalise(Object o) throws SQLException {
            if (o == null) {
                return null;
            }
            if (!(o instanceof CLOB)) {
                throw new UnsupportedOperationException("OracleClobNormaliser cannot work with " + o.getClass());
            }
            CLOB clob = (CLOB)o;
            if (clob.length() > 10000L) {
                throw new UnsupportedOperationException("Clobs larger than 10000bytes are not supported by DBFIT");
            }
            InputStream is = clob.getStream();
            String value = ResourceHelper.readFromStream(is);
            return value;
        }
    }

    public static class SqlDateNormaliser
    implements TypeNormaliser {
        public Object normalise(Object o) throws SQLException {
            if (o == null) {
                return null;
            }
            if (!(o instanceof Date)) {
                throw new UnsupportedOperationException("SqlDateNormaliser cannot work with " + o.getClass());
            }
            Date ts = (Date)o;
            return new Timestamp(ts.getTime());
        }
    }

    public static class OracleDateNormaliser
    implements TypeNormaliser {
        public Object normalise(Object o) throws SQLException {
            if (o == null) {
                return null;
            }
            if (!(o instanceof DATE)) {
                throw new UnsupportedOperationException("OracleDateNormaliser cannot work with " + o.getClass());
            }
            DATE ts = (DATE)o;
            return ts.timestampValue();
        }
    }

    public static class OracleTimestampNormaliser
    implements TypeNormaliser {
        public Object normalise(Object o) throws SQLException {
            if (o == null) {
                return null;
            }
            if (!(o instanceof TIMESTAMP)) {
                throw new UnsupportedOperationException("OracleTimestampNormaliser cannot work with " + o.getClass());
            }
            TIMESTAMP ts = (TIMESTAMP)o;
            return ts.timestampValue();
        }
    }

    public static class OracleTimestampParser {
        public static Object parse(String s) throws Exception {
            return new TIMESTAMP((Timestamp)SqlTimestampParseDelegate.parse(s));
        }
    }
}

