/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.impl;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jtester.module.database.environment.AbstractDBEnvironment;
import org.jtester.module.database.environment.normalise.NameNormaliser;
import org.jtester.module.database.util.DBHelper;
import org.jtester.module.database.util.DataSourceType;
import org.jtester.module.dbfit.db.model.DbParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlServerEnvironment
extends AbstractDBEnvironment {
    private static String paramNamePattern = "@([A-Za-z0-9_]+)";
    private static Pattern paramRegex = Pattern.compile(paramNamePattern);
    private static List<String> stringTypes = Arrays.asList("VARCHAR", "NVARCHAR", "CHAR", "NCHAR", "TEXT", "NTEXT", "UNIQUEIDENTIFIER");
    private static List<String> intTypes = Arrays.asList("INT");
    private static List<String> booleanTypes = Arrays.asList("BIT");
    private static List<String> floatTypes = Arrays.asList("REAL");
    private static List<String> doubleTypes = Arrays.asList("FLOAT");
    private static List<String> longTypes = Arrays.asList("BIGINT");
    private static List<String> shortTypes = Arrays.asList("TINYINT", "SMALLINT");
    private static List<String> decimalTypes = Arrays.asList("DECIMAL", "NUMERIC", "MONEY", "SMALLMONEY");
    private static List<String> timestampTypes = Arrays.asList("SMALLDATETIME", "DATETIME", "TIMESTAMP");

    public SqlServerEnvironment(String dataSourceName, String dataSourceFrom) {
        super(DataSourceType.SQLSERVER, dataSourceName, dataSourceFrom);
        this.typeMap = null;
    }

    @Override
    public boolean supportsOuputOnInsert() {
        return false;
    }

    @Override
    public Pattern getParameterPattern() {
        return paramRegex;
    }

    @Override
    protected String parseCommandText(String commandText, String[] vars) {
        if (vars == null || vars.length == 0) {
            return commandText;
        }
        String sql = commandText;
        for (String var : vars) {
            sql = sql.replace("@" + var, "?");
        }
        return sql;
    }

    @Override
    public Map<String, DbParameterAccessor> getAllColumns(String tableOrViewName) throws SQLException {
        String qry = " select c.[name], TYPE_NAME(c.system_type_id) as [Type], c.max_length,  0 As is_output, 0 As is_cursor_ref  from sys.columns c  where c.object_id = OBJECT_ID(?)  order by column_id";
        return this.readIntoParams(tableOrViewName, qry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbParameterAccessor> readIntoParams(String objname, String query) throws SQLException {
        HashMap<String, DbParameterAccessor> hashMap;
        if (objname.contains(".")) {
            String[] schemaAndName = objname.split("[\\.]", 2);
            objname = "[" + schemaAndName[0] + "].[" + schemaAndName[1] + "]";
        } else {
            objname = "[" + NameNormaliser.normaliseName(objname) + "]";
        }
        PreparedStatement dc = null;
        ResultSet rs = null;
        try {
            dc = this.connection.prepareStatement(query);
            dc.setString(1, NameNormaliser.normaliseName(objname));
            rs = dc.executeQuery();
            HashMap<String, DbParameterAccessor> allParams = new HashMap<String, DbParameterAccessor>();
            int position = 0;
            while (rs.next()) {
                String paramName = rs.getString(1);
                if (paramName == null) {
                    paramName = "";
                }
                String dataType = rs.getString(2);
                int direction = rs.getInt(4);
                int paramDirection = paramName.trim().length() == 0 ? 0 : SqlServerEnvironment.getParameterDirection(direction);
                DbParameterAccessor dbp = new DbParameterAccessor(paramName, paramDirection, SqlServerEnvironment.getSqlType(dataType), this.getJavaClass(dataType), position++);
                allParams.put(NameNormaliser.normaliseName(paramName), dbp);
            }
            hashMap = allParams;
        }
        catch (Throwable throwable) {
            DBHelper.closeResultSet(rs);
            rs = null;
            DBHelper.closeStatement(dc);
            dc = null;
            throw throwable;
        }
        DBHelper.closeResultSet(rs);
        rs = null;
        DBHelper.closeStatement(dc);
        dc = null;
        return hashMap;
    }

    private static int getParameterDirection(int isOutput) {
        if (isOutput == 1) {
            return 2;
        }
        return 1;
    }

    private static String normaliseTypeName(String dataType) {
        int idx = (dataType = dataType.toUpperCase().trim()).indexOf(" ");
        if (idx >= 0) {
            dataType = dataType.substring(0, idx);
        }
        if ((idx = dataType.indexOf("(")) >= 0) {
            dataType = dataType.substring(0, idx);
        }
        return dataType;
    }

    private static int getSqlType(String dataType) {
        if (stringTypes.contains(dataType = SqlServerEnvironment.normaliseTypeName(dataType))) {
            return 12;
        }
        if (decimalTypes.contains(dataType)) {
            return 2;
        }
        if (intTypes.contains(dataType)) {
            return 4;
        }
        if (timestampTypes.contains(dataType)) {
            return 93;
        }
        if (booleanTypes.contains(dataType)) {
            return 16;
        }
        if (floatTypes.contains(dataType)) {
            return 6;
        }
        if (doubleTypes.contains(dataType)) {
            return 8;
        }
        if (longTypes.contains(dataType)) {
            return -5;
        }
        if (shortTypes.contains(dataType)) {
            return 5;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Class getJavaClass(String dataType) {
        if (stringTypes.contains(dataType = SqlServerEnvironment.normaliseTypeName(dataType))) {
            return String.class;
        }
        if (decimalTypes.contains(dataType)) {
            return BigDecimal.class;
        }
        if (intTypes.contains(dataType)) {
            return Integer.class;
        }
        if (timestampTypes.contains(dataType)) {
            return Timestamp.class;
        }
        if (booleanTypes.contains(dataType)) {
            return Boolean.class;
        }
        if (floatTypes.contains(dataType)) {
            return Float.class;
        }
        if (doubleTypes.contains(dataType)) {
            return Double.class;
        }
        if (longTypes.contains(dataType)) {
            return Long.class;
        }
        if (shortTypes.contains(dataType)) {
            return Short.class;
        }
        throw new UnsupportedOperationException("Type " + dataType + " is not supported");
    }

    @Override
    public Map<String, DbParameterAccessor> getAllProcedureParameters(String procName) throws SQLException {
        return this.readIntoParams(procName, "select p.[name], TYPE_NAME(p.system_type_id) as [Type],   p.max_length, p.is_output, p.is_cursor_ref from sys.parameters p  where p.object_id = OBJECT_ID(?) order by parameter_id ");
    }

    @Override
    public String getFieldQuato() {
        return "";
    }
}

