/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.typesmap;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.jtester.module.database.environment.typesmap.AbstractTypeMap;
import org.jtester.module.database.environment.typesmap.TypeMap;

public class MySQLTypeMap
extends AbstractTypeMap {
    private static TypeMap maps = new TypeMap(){
        private static final long serialVersionUID = -2101070752077610108L;
        {
            this.put("VARCHAR", String.class, 12);
            this.put("CHAR", String.class, 12);
            this.put("TEXT", String.class, 12);
            this.put("TINYTEXT", String.class, 2004);
            this.put("MEDIUMTEXT", String.class, 2004);
            this.put("LONGTEXT", String.class, 2004);
            this.put("TINYINT", Integer.class, 4);
            this.put("TINYINT UNSIGNED", Integer.class, 4);
            this.put("SMALLINT", Integer.class, 4);
            this.put("SMALLINT UNSIGNED", Integer.class, 4);
            this.put("MEDIUMINT", Integer.class, 4);
            this.put("MEDIUMINT UNSIGNED", Integer.class, 4);
            this.put("INT", Integer.class, 4);
            this.put("INT UNSIGNED", Integer.class, 4);
            this.put("INTEGER", Integer.class, 4);
            this.put("INTEGER UNSIGNED", Integer.class, 4);
            this.put("BIGINT", Long.class, -5);
            this.put("BIGINT UNSIGNED", Long.class, -5);
            this.put("FLOAT", Float.class, 6);
            this.put("FLOAT UNSIGNED", Float.class, 6);
            this.put("DOUBLE", Double.class, 8);
            this.put("DOUBLE UNSIGNED", Double.class, 8);
            this.put("DECIMAL", BigDecimal.class, 2);
            this.put("DECIMAL UNSIGNED", BigDecimal.class, 2);
            this.put("DEC", BigDecimal.class, 2);
            this.put("DEC UNSIGNED", BigDecimal.class, 2);
            this.put("DATE", Date.class, 91);
            this.put("TIMESTAMP", Timestamp.class, 93);
            this.put("DATETIME", Timestamp.class, 93);
            this.put("YEAR", Integer.class, 4);
            this.put("BIT", Boolean.class, 16);
            this.put("CHARACTER VARYING", String.class, 12);
            this.put("NUMERIC", Double.class, 2);
            this.put("DOUBLE PRECISION", Double.class, 8);
            this.put("CHARACTER", String.class, 1);
            this.put("TIME", Time.class, 92);
            this.put("BOOLEAN", Boolean.class, -7);
            this.put("TIMESTAMP WITH TIME ZONE", Date.class, 91);
            this.put("TIMESTAMP WITHOUT TIME ZONE", Date.class, 91);
            this.put("TIME WITH TIME ZONE", Time.class, 92);
            this.put("TIME WITHOUT TIME ZONE", Time.class, 92);
            this.put("ENUM", String.class, 12);
            this.put("SET", String.class, 12);
            this.put("BLOB", String.class, 2004);
            this.put("LONGBLOB", String.class, 2004);
            this.put("MEDIUMBLOB", String.class, 2004);
            this.put("TINYBLOB", String.class, 2004);
            this.put("BINARY", InputStream.class, -2);
            this.put("VARBINARY", InputStream.class, -2);
        }
    };
    private static Map<String, Class> types = new HashMap<String, Class>(){};

    public static Class getJavaType(String type) {
        TypeMap.JavaSQLType map = (TypeMap.JavaSQLType)maps.get(type);
        return map == null ? null : map.getJavaType();
    }

    public static Integer getSQLType(String type) {
        TypeMap.JavaSQLType map = (TypeMap.JavaSQLType)maps.get(type);
        return map == null ? null : Integer.valueOf(map.getSqlType());
    }

    protected Class getJavaTypeByName(String typeName) {
        Class type = types.get(typeName);
        return type == null ? String.class : type;
    }

    protected Object toObjectByType(String input, Class javaType) {
        return input;
    }

    protected Object getDefaultValue(Class javaType) {
        return null;
    }
}

