/*
 * Decompiled with CFR 0.152.
 */
package org.jtester.module.database.environment.typesmap;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.TIMESTAMP;
import org.jtester.module.database.environment.typesmap.AbstractTypeMap;
import org.jtester.module.database.environment.typesmap.TypeMap;
import org.jtester.utility.DateUtil;

public class OracleTypeMap
extends AbstractTypeMap {
    private static TypeMap maps = new TypeMap(){
        private static final long serialVersionUID = 4142728734422012716L;
        {
            this.put("VARCHAR", String.class, 12);
            this.put("VARCHAR2", String.class, 12);
            this.put("NVARCHAR2", String.class, 12);
            this.put("CHAR", String.class, 12);
            this.put("NCHAR", String.class, 12);
            this.put("CLOB", CLOB.class, 2005);
            this.put("BLOB", BLOB.class, 2004);
            this.put("RAW", byte[].class, -2);
            this.put("ROWID", String.class, 12);
            this.put("BINARY_INTEGER", BigDecimal.class, 2);
            this.put("NUMBER", BigDecimal.class, 2);
            this.put("FLOAT", BigDecimal.class, 2);
            this.put("DATE", Timestamp.class, 93);
            this.put("TIMESTAMP", Timestamp.class, 93);
            this.put("REF", ResultSet.class, -10);
            this.put("LONGVARCHAR", String.class, 12);
            this.put("NUMERIC", BigDecimal.class, 3);
            this.put("DECIMAL", BigDecimal.class, 3);
            this.put("BIT", Boolean.class, 16);
            this.put("TINYINT", Byte.class, -7);
            this.put("SMALLINT", Short.class, 5);
        }
    };
    public static Map<String, Class> types = new HashMap<String, Class>(){
        {
            this.put("oracle.sql.CLOB", CLOB.class);
            this.put("oracle.sql.BLOB", BLOB.class);
            this.put("oracle.sql.TIMESTAMP", TIMESTAMP.class);
        }
    };

    public static Class getJavaType(String type) {
        TypeMap.JavaSQLType map = (TypeMap.JavaSQLType)maps.get(type);
        return map == null ? null : map.getJavaType();
    }

    public static Integer getSQLType(String type) {
        TypeMap.JavaSQLType map = (TypeMap.JavaSQLType)maps.get(type);
        return map == null ? null : Integer.valueOf(map.getSqlType());
    }

    public Object toObjectByType(String input, Class javaType) {
        if (javaType == TIMESTAMP.class) {
            long time = DateUtil.parse(input).getTime();
            Timestamp stamp = new Timestamp(time);
            return new TIMESTAMP(stamp);
        }
        if (javaType == CLOB.class || javaType == BLOB.class) {
            InputStream is = this.getStream(input);
            return is;
        }
        return input;
    }

    protected Class getJavaTypeByName(String typeName) {
        Class type = types.get(typeName);
        return type == null ? String.class : type;
    }

    protected Object getDefaultValue(Class javaType) {
        if (javaType == TIMESTAMP.class) {
            Date now = new Date();
            Timestamp stamp = new Timestamp(now.getTime());
            return new TIMESTAMP(stamp);
        }
        if (javaType == CLOB.class || javaType == BLOB.class) {
            InputStream is = this.getStream("stream");
            return is;
        }
        return null;
    }
}

